/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app;

import java.io.BufferedWriter;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import javafx.application.Platform;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import org.apache.commons.io.FilenameUtils;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Input;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.app.Results;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.gui.layout.MyText;

public class ExportTask
extends Task<Integer> {
    protected static MyText exportInfoText = new MyText(true);

    protected Integer call() throws Exception {
        this.updateUIinfoText("Exporting results to textfile...");
        String outputfilename = Input.getDatabaseDirPath() + "/" + FilenameUtils.getBaseName((String)Input.getTextfileName()) + "_results.txt";
        BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(outputfilename), "utf-8"));
        ObservableList items = Results.getResultNotations().getItems();
        items.forEach(item -> {
            try {
                writer.write(item.getId() + "\t" + item.getHelmNotation() + "\n");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
        ((Writer)writer).close();
        this.updateUIinfoText("Export done to: " + outputfilename + ".");
        return null;
    }

    private void updateUIinfoText(final String text) {
        Platform.runLater((Runnable)new Runnable(){

            @Override
            public void run() {
                exportInfoText.setText(text);
            }
        });
    }
}

