/*
 * Decompiled with CFR 0.152.
 */
package org.pistoiaalliance.helm.HELMSimilarityLibrary;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.BitSet;
import java.util.Set;
import javax.xml.bind.DatatypeConverter;
import org.helm.notation2.parser.notation.HELM2Notation;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.PathGenerator;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.utils.Graph;
import org.pistoiaalliance.helm.HELMSimilarityLibrary.utils.MoleculeGraphUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Fingerprinter {
    private static int size = 1024;
    private static final Logger LOG = LoggerFactory.getLogger(Fingerprinter.class);

    public static BitSet calculateFingerprint(HELM2Notation notation) throws Exception {
        PathGenerator pathGenerator = new PathGenerator();
        Graph molecule = MoleculeGraphUtils.buildMoleculeGraph(notation.getListOfPolymers(), notation.getListOfConnections());
        pathGenerator.findPaths(molecule);
        Set<String> allPaths = pathGenerator.getPaths();
        BitSet fingerprint = Fingerprinter.getHashedFingerprint(allPaths);
        pathGenerator.clearPaths();
        allPaths.clear();
        return fingerprint;
    }

    public static BitSet calculateFingerprintNaturalAnalogs(HELM2Notation notation) throws Exception {
        PathGenerator pathGenerator = new PathGenerator();
        Graph molecule = MoleculeGraphUtils.buildMoleculeGraph(notation.getListOfPolymers(), notation.getListOfConnections());
        pathGenerator.findPaths(molecule);
        Set<String> allPaths = pathGenerator.getPaths();
        Set<String> allNaturalPaths = pathGenerator.getNaturalPaths();
        BitSet fingerprint = Fingerprinter.getHashedFingerprint(allPaths);
        BitSet fingerprintNatural = Fingerprinter.getHashedFingerprint(allNaturalPaths);
        fingerprintNatural.or(fingerprint);
        pathGenerator.clearPaths();
        allPaths.clear();
        allNaturalPaths.clear();
        return fingerprintNatural;
    }

    public static BitSet getHashedFingerprint(Set<String> totalPaths) throws NoSuchAlgorithmException {
        BitSet bitSet = new BitSet(size);
        LOG.debug("Calculation of fingerprint started.");
        for (String path : totalPaths) {
            bitSet.set(Fingerprinter.getBitposFromHashcode(path));
        }
        LOG.debug("Calculation of fingerprint successful.");
        return bitSet;
    }

    private static int getBitposFromHashcode(String path) throws NoSuchAlgorithmException {
        MessageDigest digest = MessageDigest.getInstance("SHA-256");
        byte[] hash = digest.digest(path.getBytes(StandardCharsets.UTF_8));
        String hashString = DatatypeConverter.printHexBinary((byte[])hash);
        BitSet pathBitSet = BitSet.valueOf(DatatypeConverter.parseHexBinary((String)hashString));
        pathBitSet = Fingerprinter.foldBitSet(pathBitSet);
        return Fingerprinter.getDecimalFromBitSet(pathBitSet);
    }

    private static int getDecimalFromBitSet(BitSet bitSet) {
        if (bitSet.isEmpty()) {
            return 0;
        }
        StringBuilder s = new StringBuilder();
        for (int i = 0; i < bitSet.size(); ++i) {
            s.append(bitSet.get(i) ? 1 : 0);
        }
        String str = s.toString();
        str = str.substring(0, 10);
        int decimal = 0;
        int base0 = 48;
        for (int i = 0; i < str.length(); ++i) {
            decimal = decimal * 2 + (str.charAt(i) - base0);
        }
        return decimal;
    }

    private static BitSet foldBitSet(BitSet pathBitSet) {
        LOG.debug("Folding bit set...");
        BitSet firstHalf = pathBitSet.get(0, pathBitSet.size() / 2);
        BitSet secondHalf = pathBitSet.get(pathBitSet.size() / 2, pathBitSet.size());
        BitSet temp = firstHalf;
        for (int size = 128; size >= 10; size /= 2) {
            firstHalf.xor(secondHalf);
            temp = firstHalf;
            firstHalf = temp.get(0, size / 2);
            secondHalf = temp.get(size / 2, size);
        }
        firstHalf = temp.get(0, 10);
        secondHalf = temp.get(10, 16);
        for (int i = 0; i < 6; ++i) {
            boolean xorValue = !(!firstHalf.get(i) && !secondHalf.get(i) || firstHalf.get(i) && secondHalf.get(i));
            firstHalf.set(i, xorValue);
        }
        LOG.debug("Folding bit set successful.");
        return firstHalf;
    }
}

