#!/usr/bin/env pwsh

Set-StrictMode -Version latest
$ErrorActionPreference = "Stop"

# Build kube config from environment variables
$KUBECONFIG = @"
apiVersion: v1
clusters:
- cluster:
    certificate-authority-data: $env:KUBECONFIG_STAGE_CLUSTER_CA
    server: $env:KUBECONFIG_STAGE_CLUSTER_SERVER
  name: $env:KUBECONFIG_STAGE_CLUSTER_NAME
contexts:
- context:
    cluster: $env:KUBECONFIG_STAGE_CLUSTER_NAME
    namespace: $env:KUBECONFIG_CONTEXT_NAMESPACE
    user: $env:KUBECONFIG_STAGE_CLUSTER_NAME-admin
  name: $env:KUBECONFIG_STAGE_CLUSTER_NAME
current-context: $env:KUBECONFIG_STAGE_CLUSTER_NAME
kind: Config
preferences: {}
users:
- name: $env:KUBECONFIG_STAGE_CLUSTER_NAME-admin
  user:
    client-certificate-data: $env:KUBECONFIG_STAGE_USER_CA
    client-key-data: $env:KUBECONFIG_STAGE_USER_KEY
"@

# Create kube config and set secure permissions
Set-Content -Path "~/.kube/config" -Value $KUBECONFIG -Force

Write-Host "kube config configured to '$env:KUBECONFIG_STAGE_CLUSTER_NAME' cluster"