function Read-Component {
    [CmdletBinding()]
    param (
        [Alias("Path")]
        [Parameter(Mandatory = $true, Position = 0)]
        [string] $ComponentPath
    )
    
    # Verify component file exists
    if (($ComponentPath -eq $null) -or ($ComponentPath -eq "") -or (-not (Test-Path -Path $ComponentPath))) {
        Write-Host "Didn't find a component file at '$ComponentPath'"
    }

    # Read the component metadata
    $component = Get-Content -Path $ComponentPath | ConvertFrom-Json
    Write-Output $component
}

function Write-Component {
    [CmdletBinding()]
    param (
        [Alias("Path")]
        [Parameter(Mandatory = $true, Position = 0)]
        [string] $ComponentPath,
        [Parameter(Mandatory = $true, Position = 1)]
        [object] $Component
    )

    # Write the content to component file
    $Component | ConvertTo-Json | % { [System.Text.RegularExpressions.Regex]::Unescape($_) } | Set-Content -Path $ComponentPath
}
