/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.swagger.controllers;

import com.fasterxml.jackson.core.JsonProcessingException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.pipservices4.commons.convert.JsonConverter;
import org.pipservices4.http.controllers.ISwaggerController;
import org.pipservices4.http.controllers.RestController;

public class SwaggerController
extends RestController
implements ISwaggerController {
    private final HashMap<String, String> _routes = new HashMap();

    public SwaggerController() {
        this._baseRoute = "swagger";
    }

    private InputStreamReader getFileStream(String fileName) {
        return new InputStreamReader(Objects.requireNonNull(SwaggerController.class.getClassLoader().getResourceAsStream(fileName)));
    }

    private String calculateContentType(String fileName) {
        String ext;
        return switch (ext = Optional.of(fileName).filter(f -> f.contains(".")).map(f -> f.substring(fileName.lastIndexOf(".") + 1)).get()) {
            case "html" -> "text/html";
            case "css" -> "text/css";
            case "js" -> "application/javascript";
            case "png" -> "image/png";
            default -> "text/plain";
        };
    }

    private boolean checkFileExist(String fileName) {
        return SwaggerController.class.getClassLoader().getResource(fileName) != null;
    }

    private String loadFileContent(String fileName) {
        StringBuilder resultStringBuilder = new StringBuilder();
        try (BufferedReader br = new BufferedReader(this.getFileStream(fileName));){
            String line;
            while ((line = br.readLine()) != null) {
                resultStringBuilder.append(line).append("\n");
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return resultStringBuilder.toString();
    }

    private Response getSwaggerFile(ContainerRequestContext req) {
        String fileName = ((String)((List)req.getUriInfo().getPathParameters().get("file_name")).get(0)).toLowerCase();
        if (!this.checkFileExist(fileName)) {
            return Response.status(404).build();
        }
        return Response.status(200).entity(this.loadFileContent(fileName)).header("Content-Type", this.calculateContentType(fileName)).build();
    }

    private Response getIndex(ContainerRequestContext req) {
        String content = this.loadFileContent("index.html");
        ArrayList<Map<String, String>> urls = new ArrayList<Map<String, String>>();
        for (String prop : this._routes.keySet()) {
            Map<String, String> url = Map.of("name", prop, "url", this._routes.get(prop));
            urls.add(url);
        }
        try {
            content = content.replace("[/*urls*/]", JsonConverter.toJson(urls));
        }
        catch (JsonProcessingException ex) {
            throw new RuntimeException(ex);
        }
        return Response.status(200).type(MediaType.TEXT_HTML_TYPE).entity(content).build();
    }

    private Response redirectToIndex(ContainerRequestContext req) {
        Object url = req.getUriInfo().getRequestUri().toString();
        if (!((String)url).endsWith("/")) {
            url = (String)url + "/";
        }
        try {
            return Response.seeOther(new URI((String)url + "index.html")).status(301).build();
        }
        catch (URISyntaxException ex) {
            throw new RuntimeException(ex);
        }
    }

    private String composeSwaggerRoute(String baseRoute, String route) {
        if (baseRoute != null && !((String)baseRoute).equals("")) {
            if (route == null || ((String)route).equals("")) {
                route = "/";
            }
            if (!((String)route).startsWith("/")) {
                route = "/" + (String)route;
            }
            if (!((String)baseRoute).startsWith("/")) {
                baseRoute = "/" + (String)baseRoute;
            }
            route = (String)baseRoute + (String)route;
        }
        return route;
    }

    @Override
    public void register() {
        String baseRoute = this._baseRoute;
        this._baseRoute = null;
        this.registerRoute("GET", baseRoute, null, this::redirectToIndex);
        this._baseRoute = baseRoute;
        this.registerRoute("GET", "/index.html", null, this::getIndex);
        this.registerRoute("GET", "/{file_name}", null, this::getSwaggerFile);
    }

    @Override
    public void registerOpenApiSpec(String baseRoute, String swaggerRoute) {
        if (swaggerRoute == null) {
            super.registerOpenApiSpec(baseRoute);
        } else {
            String route = this.composeSwaggerRoute(baseRoute, swaggerRoute);
            baseRoute = baseRoute != null ? baseRoute : "default";
            this._routes.put(baseRoute, route);
        }
    }
}

