/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.observability.log;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.errors.ErrorDescription;
import org.pipservices4.commons.errors.ErrorDescriptionFactory;
import org.pipservices4.commons.errors.InvocationException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IReconfigurable;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.observability.log.LogLevel;
import org.pipservices4.observability.log.LogMessage;
import org.pipservices4.observability.log.Logger;

public abstract class CachedLogger
extends Logger
implements IReconfigurable {
    protected List<LogMessage> _cache = new ArrayList<LogMessage>();
    protected boolean _updated = false;
    protected long _lastDumpTime = System.currentTimeMillis();
    protected long _interval = 10000L;
    protected int _maxCacheSize = 100;
    protected final Object _lock = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void write(LogLevel level, IContext context, Exception ex, String message) {
        ErrorDescription error = ex != null ? ErrorDescriptionFactory.create(ex) : null;
        String source = this.getComputerName();
        LogMessage logMessage = new LogMessage(level, source, context != null ? ContextResolver.getTraceId(context) : null, error, message);
        Object object = this._lock;
        synchronized (object) {
            this._cache.add(logMessage);
        }
        this.update();
    }

    private String getComputerName() {
        Map<String, String> env = System.getenv();
        if (env.containsKey("COMPUTERNAME")) {
            return env.get("COMPUTERNAME");
        }
        return env.getOrDefault("HOSTNAME", "Unknown Computer");
    }

    protected abstract void save(List<LogMessage> var1) throws InvocationException;

    @Override
    public void configure(ConfigParams config) {
        super.configure(config);
        this._interval = config.getAsLongWithDefault("options.interval", this._interval);
        this._maxCacheSize = config.getAsIntegerWithDefault("options.max_cache_size", this._maxCacheSize);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear() {
        Object object = this._lock;
        synchronized (object) {
            this._cache.clear();
            this._updated = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() {
        if (this._updated) {
            Object object = this._lock;
            synchronized (object) {
                block7: {
                    if (!this._updated) {
                        return;
                    }
                    List<LogMessage> messages = this._cache;
                    this._cache = new ArrayList<LogMessage>();
                    try {
                        this.save(messages);
                    }
                    catch (InvocationException e) {
                        messages.addAll(this._cache);
                        this._cache = messages;
                        int deleteCount = this._cache.size() - this._maxCacheSize;
                        if (deleteCount <= 0) break block7;
                        this._cache = this._cache.subList(deleteCount - 1, this._cache.size());
                    }
                }
                this._updated = false;
                this._lastDumpTime = System.currentTimeMillis();
            }
        }
    }

    protected void update() {
        this._updated = true;
        if (System.currentTimeMillis() > this._lastDumpTime + this._interval) {
            this.dump();
        }
    }
}

