/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.observability.count;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.errors.InvocationException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IReconfigurable;
import org.pipservices4.observability.count.Counter;
import org.pipservices4.observability.count.CounterTiming;
import org.pipservices4.observability.count.ICounterTimingCallback;
import org.pipservices4.observability.count.ICounters;

public abstract class CachedCounters
implements ICounters,
IReconfigurable,
ICounterTimingCallback {
    private final Map<String, Counter> _cache = new HashMap<String, Counter>();
    private boolean _updated = false;
    private long _lastDumpTime = System.currentTimeMillis();
    protected long _lastResetTime = System.currentTimeMillis();
    private long _interval = 300000L;
    private final Object _lock = new Object();
    protected long _resetTimeout = 0L;

    protected CachedCounters() {
    }

    protected abstract void save(List<Counter> var1) throws InvocationException;

    @Override
    public void configure(ConfigParams config) {
        this._interval = config.getAsLongWithDefault("interval", this._interval);
        this._interval = config.getAsLongWithDefault("options.interval", this._interval);
        this._resetTimeout = config.getAsLongWithDefault("reset_timeout", this._resetTimeout);
        this._resetTimeout = config.getAsLongWithDefault("options.reset_timeout", this._resetTimeout);
    }

    public long getInterval() {
        return this._interval;
    }

    public void setInterval(long value) {
        this._interval = value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clear(String name) {
        Object object = this._lock;
        synchronized (object) {
            this._cache.remove(name);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearAll() {
        Object object = this._lock;
        synchronized (object) {
            this._cache.clear();
            this._updated = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dump() throws InvocationException {
        if (this._updated) {
            List<Counter> counters = this.getAll();
            this.save(counters);
            Object object = this._lock;
            synchronized (object) {
                this._updated = false;
                this._lastDumpTime = System.currentTimeMillis();
            }
        }
    }

    protected void update() {
        this._updated = true;
        if (System.currentTimeMillis() > this._lastDumpTime + this._interval) {
            try {
                this.dump();
            }
            catch (InvocationException invocationException) {
                // empty catch block
            }
        }
    }

    private void resetIfNeeded() {
        if (this._resetTimeout == 0L) {
            return;
        }
        if (System.currentTimeMillis() - this._lastResetTime > this._resetTimeout) {
            this._cache.clear();
            this._updated = false;
            this._lastResetTime = System.currentTimeMillis();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Counter> getAll() {
        Object object = this._lock;
        synchronized (object) {
            this.resetIfNeeded();
            return new ArrayList<Counter>(this._cache.values());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Counter get(String name, int type) {
        if (name == null || name.isEmpty()) {
            throw new NullPointerException("Counter name was not set");
        }
        Object object = this._lock;
        synchronized (object) {
            this.resetIfNeeded();
            Counter counter = this._cache.get(name);
            if (counter == null || counter.getType() != type) {
                counter = new Counter(name, type);
                this._cache.put(name, counter);
            }
            return counter;
        }
    }

    private void calculateStats(Counter counter, float value) {
        if (counter == null) {
            throw new NullPointerException("Counter cannot be null");
        }
        counter.setLast(Float.valueOf(value));
        counter.setCount(counter.getCount() != null ? counter.getCount() + 1 : 1);
        counter.setMax(Float.valueOf(counter.getMax() != null ? Math.max(counter.getMax().floatValue(), value) : value));
        counter.setMin(Float.valueOf(counter.getMin() != null ? Math.min(counter.getMin().floatValue(), value) : value));
        counter.setAverage(Float.valueOf(counter.getAverage() != null && counter.getCount() > 1 ? (counter.getAverage().floatValue() * (float)(counter.getCount() - 1) + value) / (float)counter.getCount().intValue() : value));
    }

    @Override
    public CounterTiming beginTiming(String name) {
        return new CounterTiming(name, this);
    }

    @Override
    public void endTiming(String name, float elapsed) {
        Counter counter = this.get(name, 0);
        this.calculateStats(counter, elapsed);
        this.update();
    }

    @Override
    public void stats(String name, float value) {
        Counter counter = this.get(name, 2);
        this.calculateStats(counter, value);
        this.update();
    }

    @Override
    public void last(String name, float value) {
        Counter counter = this.get(name, 1);
        counter.setLast(Float.valueOf(value));
        this.update();
    }

    @Override
    public void timestampNow(String name) {
        this.timestamp(name, ZonedDateTime.now());
    }

    @Override
    public void timestamp(String name, ZonedDateTime value) {
        Counter counter = this.get(name, 3);
        counter.setTime(value != null ? value : ZonedDateTime.now(ZoneId.of("Z")));
        this.update();
    }

    @Override
    public void incrementOne(String name) {
        this.increment(name, 1);
    }

    @Override
    public void increment(String name, int value) {
        Counter counter;
        counter.setCount((counter = this.get(name, 4)).getCount() != null ? counter.getCount() + value : value);
        this.update();
    }
}

