/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.logic.state;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IReconfigurable;
import org.pipservices4.components.context.IContext;
import org.pipservices4.logic.state.IStateStore;
import org.pipservices4.logic.state.StateEntry;
import org.pipservices4.logic.state.StateValue;

public class MemoryStateStore
implements IStateStore,
IReconfigurable {
    private final HashMap<String, StateEntry> _states = new HashMap();
    private long _timeout = 0L;

    @Override
    public void configure(ConfigParams configParams) throws ConfigException {
        this._timeout = configParams.getAsLongWithDefault("options.timeout", this._timeout);
    }

    private void cleanup() {
        if (this._timeout == 0L) {
            return;
        }
        long cutOffTime = System.currentTimeMillis() - this._timeout;
        for (String key : this._states.keySet()) {
            StateEntry entry = this._states.get(key);
            if (entry.getLastUpdateTime() >= cutOffTime) continue;
            this._states.remove(key);
        }
    }

    @Override
    public <T> T load(IContext context, String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        this.cleanup();
        StateEntry entry = this._states.getOrDefault(key, null);
        if (entry == null) {
            return null;
        }
        return (T)entry.getValue();
    }

    @Override
    public <T> List<StateValue<T>> loadBulk(IContext context, List<String> keys) {
        this.cleanup();
        ArrayList<StateValue<T>> result = new ArrayList<StateValue<T>>();
        for (String key : keys) {
            T value = this.load(context, key);
            result.add(new StateValue<T>(key, value));
        }
        return result;
    }

    @Override
    public <T> T save(IContext context, String key, T value) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        this.cleanup();
        StateEntry entry = this._states.getOrDefault(key, null);
        if (value == null) {
            this._states.remove(key);
            return null;
        }
        if (entry != null) {
            entry.setValue(value);
        } else {
            entry = new StateEntry(key, value);
            this._states.put(key, entry);
        }
        return value;
    }

    @Override
    public <T> T delete(IContext context, String key) {
        if (key == null) {
            throw new NullPointerException("Key cannot be null");
        }
        this.cleanup();
        StateEntry entry = this._states.getOrDefault(key, null);
        if (entry != null) {
            this._states.remove(key);
            return (T)entry.getValue();
        }
        return null;
    }
}

