/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.http.controllers;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import org.glassfish.jersey.process.Inflector;
import org.pipservices4.commons.convert.StringConverter;
import org.pipservices4.commons.data.StringValueMap;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.context.ContextInfo;
import org.pipservices4.components.exec.Parameters;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.http.controllers.RestController;

public class StatusRestController
extends RestController {
    private final ZonedDateTime _startTime = ZonedDateTime.now();
    private IReferences _references;
    private ContextInfo _contextInfo;
    private String _route = "status";

    public StatusRestController() {
        this._dependencyResolver.put("context-info", new Descriptor("pip-services", "context-info", "default", "*", "1.0"));
    }

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        super.configure(config);
        this._route = config.getAsStringWithDefault("route", this._route);
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        this._references = references;
        super.setReferences(references);
        this._contextInfo = (ContextInfo)this._dependencyResolver.getOneOptional("context-info");
    }

    @Override
    public void register() {
        this.registerRoute("GET", this._route, new Inflector<ContainerRequestContext, Response>(){

            @Override
            public Response apply(ContainerRequestContext request) {
                return StatusRestController.this.status(request);
            }
        });
    }

    private Response status(ContainerRequestContext request) {
        String id = this._contextInfo != null ? this._contextInfo.getContextId() : "";
        String name = this._contextInfo != null ? this._contextInfo.getName() : "Unknown";
        String description = this._contextInfo != null ? this._contextInfo.getDescription() : "";
        long uptime = Duration.between(this._startTime, ZonedDateTime.now()).toMillis();
        StringValueMap properties = this._contextInfo != null ? this._contextInfo.getProperties() : null;
        ArrayList<String> components = new ArrayList<String>();
        if (this._references != null) {
            for (Object locator : this._references.getAllLocators()) {
                components.add(locator.toString());
            }
        }
        Parameters status = Parameters.fromTuples("id", id, "name", name, "description", description, "start_time", StringConverter.toString(this._startTime), "current_time", StringConverter.toString(ZonedDateTime.now()), "uptime", uptime, "properties", properties, "components", components);
        return this.sendResult(status);
    }
}

