/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.http.controllers;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Map;
import java.util.function.Function;
import org.pipservices4.commons.convert.StringConverter;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.context.ContextInfo;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.http.controllers.RestOperations;

public class StatusOperations
extends RestOperations {
    private final ZonedDateTime _startTime = ZonedDateTime.now();
    private IReferences _references2;
    private ContextInfo _contextInfo;

    public StatusOperations() {
        this._dependencyResolver.put("context-info", new Descriptor("pip-services", "context-info", "default", "*", "1.0"));
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        this._references2 = references;
        super.setReferences(references);
        this._contextInfo = this._dependencyResolver.getOneOptional(ContextInfo.class, "context-info");
    }

    public Function<ContainerRequestContext, Response> getStatusOperation() {
        return this::status;
    }

    public Response status(ContainerRequestContext req) {
        String id = this._contextInfo != null ? this._contextInfo.getContextId() : "";
        String name = this._contextInfo != null ? this._contextInfo.getName() : "Unknown";
        String description = this._contextInfo != null ? this._contextInfo.getDescription() : "";
        long uptime = System.currentTimeMillis() - this._startTime.toInstant().toEpochMilli();
        String properties = this._contextInfo != null ? this._contextInfo.getProperties() : "";
        ArrayList<String> components = new ArrayList<String>();
        if (this._references2 != null) {
            for (Object locator : this._references2.getAllLocators()) {
                components.add(locator.toString());
            }
        }
        Map status = Map.of("id", id, "name", name, "description", description, "start_time", StringConverter.toString(this._startTime), "current_time", StringConverter.toString(ZonedDateTime.now()), "uptime", uptime, "properties", properties, "components", components);
        return this.sendResult(status);
    }
}

