/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.http.controllers;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.MediaType;
import jakarta.ws.rs.core.Response;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.function.Function;
import org.glassfish.jersey.process.Inflector;
import org.pipservices4.commons.convert.JsonConverter;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.commons.errors.InvalidStateException;
import org.pipservices4.commons.errors.InvocationException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.DependencyResolver;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.IUnreferenceable;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.components.run.IOpenable;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.http.controllers.AuthorizeFunction;
import org.pipservices4.http.controllers.HttpEndpoint;
import org.pipservices4.http.controllers.HttpResponseSender;
import org.pipservices4.http.controllers.IRegisterable;
import org.pipservices4.http.controllers.ISwaggerController;
import org.pipservices4.observability.count.CompositeCounters;
import org.pipservices4.observability.count.CounterTiming;
import org.pipservices4.observability.log.CompositeLogger;
import org.pipservices4.observability.trace.CompositeTracer;
import org.pipservices4.observability.trace.TraceTiming;
import org.pipservices4.rpc.trace.InstrumentTiming;

public abstract class RestController
implements IOpenable,
IConfigurable,
IReferenceable,
IUnreferenceable,
IRegisterable {
    private static final ConfigParams _defaultConfig = ConfigParams.fromTuples("base_route", "", "dependencies.endpoint", "*:endpoint:http:*:1.0", "dependencies.swagger", "*:swagger-controller:*:*:1.0");
    protected ConfigParams _config;
    private IReferences _references;
    private boolean _localEndpoint;
    private boolean _opened;
    protected String _baseRoute;
    protected HttpEndpoint _endpoint;
    protected DependencyResolver _dependencyResolver = new DependencyResolver(_defaultConfig);
    protected CompositeLogger _logger = new CompositeLogger();
    protected CompositeCounters _counters = new CompositeCounters();
    protected CompositeTracer _tracer = new CompositeTracer();
    protected String _url;
    protected ISwaggerController _swaggerController;
    protected boolean _swaggerEnable = false;
    protected String _swaggerRoute = "swagger";

    protected RestController() {
    }

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        this._config = config.setDefaults(_defaultConfig);
        this._dependencyResolver.configure(config);
        this._baseRoute = config.getAsStringWithDefault("base_route", this._baseRoute);
        this._swaggerEnable = config.getAsBooleanWithDefault("swagger.enable", this._swaggerEnable);
        this._swaggerRoute = config.getAsStringWithDefault("swagger.route", this._swaggerRoute);
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        this._logger.setReferences(references);
        this._counters.setReferences(references);
        this._tracer.setReferences(references);
        this._dependencyResolver.setReferences(references);
        this._references = references;
        this._endpoint = (HttpEndpoint)this._dependencyResolver.getOneOptional("endpoint");
        if (this._endpoint == null) {
            this._endpoint = this.createLocalEndpoint();
            this._localEndpoint = true;
        } else {
            this._localEndpoint = false;
        }
        this._endpoint.register(this);
        this._swaggerController = this._dependencyResolver.getOneOptional(ISwaggerController.class, "swagger");
    }

    @Override
    public void unsetReferences() {
        if (this._endpoint != null) {
            this._endpoint.unregister(this);
            this._endpoint = null;
        }
        this._swaggerController = null;
    }

    private HttpEndpoint createLocalEndpoint() throws ConfigException, ReferenceException {
        HttpEndpoint endpoint = new HttpEndpoint();
        if (this._config != null) {
            endpoint.configure(this._config);
        }
        if (this._references != null) {
            endpoint.setReferences(this._references);
        }
        return endpoint;
    }

    protected InstrumentTiming instrument(IContext context, String name) {
        this._logger.trace(context, "Executing %s method", name);
        this._counters.incrementOne(name + ".exec_count");
        CounterTiming counterTiming = this._counters.beginTiming(name + ".exec_time");
        TraceTiming traceTiming = this._tracer.beginTrace(context, name, null);
        return new InstrumentTiming(context, name, "exec", this._logger, this._counters, counterTiming, traceTiming);
    }

    @Override
    public boolean isOpen() {
        return this._opened;
    }

    @Override
    public void open(IContext context) throws ApplicationException {
        if (this.isOpen()) {
            return;
        }
        if (this._endpoint == null) {
            this._endpoint = this.createLocalEndpoint();
            this._endpoint.register(this);
            this._localEndpoint = true;
        }
        if (this._localEndpoint) {
            this._endpoint.open(context);
        }
        this._opened = true;
    }

    @Override
    public void close(IContext context) throws ApplicationException {
        if (!this._opened) {
            return;
        }
        if (this._endpoint == null) {
            throw new InvalidStateException(ContextResolver.getTraceId(context), "NO_ENDPOINT", "HTTP endpoint is missing");
        }
        if (this._localEndpoint) {
            this._endpoint.close(context);
        }
        this._opened = false;
    }

    protected Response sendError(Exception ex) {
        return HttpResponseSender.sendError(ex);
    }

    protected Response sendResult(Object result) {
        return HttpResponseSender.sendResult(result);
    }

    protected Response sendEmptyResult() {
        return HttpResponseSender.sendEmptyResult();
    }

    protected Response sendCreatedResult(Object result) {
        return HttpResponseSender.sendCreatedResult(result);
    }

    protected Response sendDeletedResult(Object result) {
        return HttpResponseSender.sendDeletedResult(result);
    }

    protected String getQueryParameter(ContainerRequestContext request, String name) {
        String value = null;
        name = URLEncoder.encode(name, StandardCharsets.UTF_8);
        if (request.getUriInfo().getQueryParameters().containsKey(name)) {
            value = request.getUriInfo().getQueryParameters().getFirst(name);
            value = value != null ? URLDecoder.decode(value, StandardCharsets.UTF_8) : null;
        }
        return value;
    }

    protected String getBodyAsString(ContainerRequestContext request) throws ApplicationException {
        try {
            InputStream streamReader = request.getEntityStream();
            byte[] data = new byte[streamReader.available()];
            streamReader.read(data, 0, data.length);
            return new String(data, StandardCharsets.UTF_8);
        }
        catch (IOException ex) {
            throw new InvocationException(null, "READ_ERROR", "Cannot read input stream").wrap(ex);
        }
    }

    protected <T> T getBodyAsJson(Class<T> type, ContainerRequestContext request) throws ApplicationException {
        if (!request.getMediaType().toString().contains("application/json")) {
            throw new InvocationException(null, "EXPECTED_JSON", "Expected application/json media type");
        }
        String json = this.getBodyAsString(request);
        try {
            return JsonConverter.fromJson(type, json);
        }
        catch (IOException ex) {
            throw new InvocationException(null, "READ_ERROR", "Failed to deserialize request from JSON").wrap(ex);
        }
    }

    private String appendBaseRoute(String route) {
        Object object = route = route == null ? "/" : route;
        if (this._baseRoute != null && !this._baseRoute.isEmpty()) {
            Object baseRoute = this._baseRoute;
            if (((String)route).isEmpty()) {
                route = "/";
            }
            if (((String)route).charAt(0) != '/') {
                route = "/" + (String)route;
            }
            if (((String)baseRoute).charAt(0) != '/') {
                baseRoute = "/" + (String)baseRoute;
            }
            route = (String)baseRoute + (String)route;
        }
        return route;
    }

    protected void registerRoute(String method, String route, Inflector<ContainerRequestContext, Response> action) {
        if (this._endpoint == null) {
            return;
        }
        route = this.appendBaseRoute(route);
        this._endpoint.registerRoute(method, route, action);
    }

    protected void registerRoute(String method, String route, Schema schema, Inflector<ContainerRequestContext, Response> action) {
        if (this._endpoint == null) {
            return;
        }
        route = this.appendBaseRoute(route);
        this._endpoint.registerRoute(method.toUpperCase(), route, schema, action);
    }

    protected void registerRouteWithAuth(String method, String route, Schema schema, AuthorizeFunction<ContainerRequestContext, Inflector<ContainerRequestContext, Response>, Response> authorize, Inflector<ContainerRequestContext, Response> action) {
        if (this._endpoint == null) {
            return;
        }
        route = this.appendBaseRoute(route);
        this._endpoint.registerRouteWithAuth(method.toUpperCase(), route, schema, authorize, action);
    }

    protected void registerInterceptor(String route, Function<ContainerRequestContext, ?> action) {
        if (this._endpoint == null) {
            return;
        }
        route = this.appendBaseRoute(route);
        this._endpoint.registerInterceptor(route, action);
    }

    protected void registerOpenApiSpecFromFile(String path) {
        try (FileInputStream fs = new FileInputStream(path);){
            String content = new String(fs.readAllBytes(), StandardCharsets.UTF_8);
            this.registerOpenApiSpec(content);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected void registerOpenApiSpec(final String content) {
        if (!this._swaggerEnable) {
            return;
        }
        this.registerRoute("GET", this._swaggerRoute, null, new Inflector<ContainerRequestContext, Response>(){

            @Override
            public Response apply(ContainerRequestContext req) {
                return Response.status(200).entity(content).header("Content-Length", content.length()).header("Content-Type", "application/x-yaml").type(MediaType.APPLICATION_XML_TYPE).build();
            }
        });
        if (this._swaggerController != null) {
            this._swaggerController.registerOpenApiSpec(this._baseRoute, this._swaggerRoute);
        }
    }

    protected String getTraceId(ContainerRequestContext req) {
        String traceId = this.getQueryParameter(req, "trace_id");
        if (traceId == null || traceId.isEmpty()) {
            traceId = req.getHeaderString("trace_id") != null && !req.getHeaderString("trace_id").isEmpty() ? req.getHeaderString("trace_id") : req.getHeaderString("correlation_id");
        }
        return traceId;
    }

    @Override
    public abstract void register() throws ReferenceException;
}

