/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.http.controllers;

import jakarta.ws.rs.container.ContainerRequestContext;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class HttpRequestDetector {
    public static String detectPlatform(ContainerRequestContext req) {
        String ua = req.getHeaderString("user-agent");
        if (ua.contains("mobile")) {
            return "mobile";
        }
        if (ua.contains("like Mac OS X")) {
            List<String> resMatch = HttpRequestDetector.match("CPU( iPhone)? OS ([0-9\\._]+) like Mac OS X", ua);
            String version = resMatch.get(2).replace('_', '.');
            if (ua.contains("iPhone")) {
                return "iphone " + version;
            }
            if (ua.contains("iPad")) {
                return "ipad " + version;
            }
            return "macosx " + version;
        }
        if (ua.contains("Android")) {
            List<String> resMatch = HttpRequestDetector.match("Android ([0-9\\.]+)[\\);]", ua);
            String version = resMatch.get(1);
            return "android " + version;
        }
        if (ua.contains("webOS")) {
            List<String> resMatch = HttpRequestDetector.match("webOS\\/([0-9\\.]+)[\\);]", ua);
            String version = resMatch.get(1);
            return "webos " + version;
        }
        if (ua.contains("Intel Mac OS X") || ua.contains("PPC Mac OS X")) {
            List<String> resMatch = HttpRequestDetector.match("(Intel|PPC) Mac OS X ?([0-9\\._]*)[\\)\\;]", ua);
            String version = resMatch.get(2).replace("_", ".");
            return "mac " + version;
        }
        if (ua.contains("Windows NT")) {
            try {
                List<String> resMatch = HttpRequestDetector.match("Windows NT ([0-9\\._]+)[\\);]", ua);
                String version = resMatch.get(1);
                return "windows " + version;
            }
            catch (Exception ex) {
                return "unknown";
            }
        }
        return "unknown";
    }

    public static String detectBrowser(ContainerRequestContext req) {
        String ua = req.getHeaderString("user-agent");
        if (ua.contains("chrome")) {
            return "chrome";
        }
        if (ua.contains("msie")) {
            return "msie";
        }
        if (ua.contains("firefox")) {
            return "firefox";
        }
        if (ua.contains("safari")) {
            return "safari";
        }
        return ua.isEmpty() ? "unknown" : ua;
    }

    public static String detectAddress(ContainerRequestContext req) {
        int index;
        String ip = null;
        if (!req.getHeaderString("x-forwarded-for").isEmpty()) {
            ip = req.getHeaderString("x-forwarded-for").split(",")[0];
        }
        if (ip != null && (index = ip.indexOf(58)) > 0) {
            ip = ip.substring(0, index);
        }
        return ip;
    }

    private static List<String> match(String pattern, String string) {
        Pattern stringPattern = Pattern.compile(pattern);
        Matcher matcher = stringPattern.matcher(string);
        ArrayList<String> resMatch = new ArrayList<String>();
        while (matcher.find()) {
            resMatch.add(matcher.group());
        }
        return resMatch;
    }

    public static String detectServerHost(ContainerRequestContext req) throws UnknownHostException {
        return InetAddress.getLocalHost().getHostName();
    }

    public static int detectServerPort(ContainerRequestContext req) {
        return 0;
    }
}

