/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.http.controllers;

import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Stream;
import org.pipservices4.commons.convert.TypeCode;
import org.pipservices4.commons.convert.TypeConverter;
import org.pipservices4.commons.reflect.PropertyReflector;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.data.validate.ArraySchema;
import org.pipservices4.data.validate.ObjectSchema;
import org.pipservices4.rpc.commands.Command;
import org.pipservices4.rpc.commands.ICommand;

public class CommandableSwaggerDocument {
    private String content = "";
    public List<ICommand> commands;
    public String version = "3.0.2";
    public String baseRoute;
    public String infoTitle;
    public String infoDescription;
    public String infoVersion = "1";
    public String infoTermsOfService;
    public String infoContactName;
    public String infoContactUrl;
    public String infoContactEmail;
    public String infoLicenseName;
    public String infoLicenseUrl;
    protected final Map<String, Object> objectType = Map.of("type", "object");

    public CommandableSwaggerDocument(String baseRoute, ConfigParams config, List<ICommand> commands) {
        this.baseRoute = baseRoute;
        this.commands = commands != null ? commands : new ArrayList();
        config = config != null ? config : new ConfigParams();
        this.infoTitle = config.getAsStringWithDefault("name", "CommandableHttpService");
        this.infoDescription = config.getAsStringWithDefault("description", "Commandable microservice");
    }

    public String toString() {
        this.content = "";
        LinkedHashMap<String, Object> data = new LinkedHashMap<String, Object>();
        data.put("openapi", this.version);
        data.put("info", Map.of("title", this.infoTitle != null ? this.infoTitle : "null", "description", this.infoDescription != null ? this.infoDescription : "null", "version", this.infoVersion != null ? this.infoVersion : "null", "termsOfService", this.infoTermsOfService != null ? this.infoTermsOfService : "null", "contact", Map.of("name", this.infoContactName != null ? this.infoContactName : "null", "url", this.infoContactUrl != null ? this.infoContactUrl : "null", "email", this.infoContactEmail != null ? this.infoContactEmail : "null"), "license", Map.of("name", this.infoLicenseName != null ? this.infoLicenseName : "null", "url", this.infoLicenseUrl != null ? this.infoLicenseUrl : "null")));
        data.put("paths", this.createPathsData());
        this.writeData(0, data);
        return this.content;
    }

    private Map<String, Object> createPathsData() {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (ICommand command : this.commands) {
            String path = this.baseRoute + "/" + command.getName();
            if (!path.startsWith("/")) {
                path = "/" + path;
            }
            Map<String, Object> bodyData = this.createRequestBodyData(command);
            Map<String, Object> responseData = this.createResponsesData();
            data.put(path, Map.of("POST".toLowerCase(), Map.of("tags", List.of(this.baseRoute), "operationId", command.getName() != null ? command.getName() : "null", "requestBody", bodyData != null ? bodyData : "null", "responses", responseData)));
        }
        return data;
    }

    private Map<String, Object> createRequestBodyData(ICommand command) {
        Map<String, Object> schemaData = this.createSchemaData(command);
        return schemaData == null ? null : Map.of("content", Map.of("application/json", Map.of("schema", schemaData)));
    }

    private Map<String, Object> createSchemaData(ICommand command) {
        ObjectSchema schema = null;
        try {
            Field privateField = Command.class.getDeclaredField("_schema");
            privateField.setAccessible(true);
            schema = (ObjectSchema)privateField.get(command);
        }
        catch (IllegalAccessException | NoSuchFieldException reflectiveOperationException) {
            // empty catch block
        }
        if (schema == null || schema.getProperties() == null) {
            return null;
        }
        return this.createPropertyData(schema, true);
    }

    private Map<String, Object> createPropertyData(ObjectSchema schema, boolean includeRequired) {
        HashMap properties = new HashMap();
        ArrayList required = new ArrayList();
        HashMap<String, Object> data = new HashMap<String, Object>();
        schema.getProperties().forEach(property -> {
            if (property.getType() == null) {
                properties.put(property.getName(), this.objectType);
            } else {
                String propertyName = property.getName();
                Object propertyType = property.getType();
                if (propertyType instanceof ArraySchema) {
                    properties.put(propertyName, Map.of("type", "array", "items", this.createPropertyTypeData(((ArraySchema)propertyType).getValueType())));
                } else {
                    properties.put(propertyName, this.createPropertyTypeData(propertyType));
                }
                if (includeRequired && property.isRequired()) {
                    required.add(propertyName);
                }
            }
        });
        data.put("properties", properties);
        if (!required.isEmpty()) {
            data.put("required", required);
        }
        return data;
    }

    private Map<String, Object> createPropertyTypeData(Object propertyType) {
        if (propertyType instanceof ObjectSchema) {
            Map<String, Object> objectMap = this.createPropertyData((ObjectSchema)propertyType, false);
            HashMap<String, Object> newMap = new HashMap<String, Object>();
            newMap.putAll(this.objectType);
            newMap.putAll(objectMap);
            return newMap;
        }
        TypeCode typeCode = Arrays.stream(TypeCode.values()).toList().contains(propertyType) ? (TypeCode)((Object)propertyType) : TypeConverter.toTypeCode(propertyType);
        if (typeCode == TypeCode.Unknown || typeCode == TypeCode.Map) {
            typeCode = TypeCode.Object;
        }
        return switch (typeCode) {
            case TypeCode.Integer -> Map.of("type", "integer", "format", "int32");
            case TypeCode.Long -> Map.of("type", "number", "format", "int64");
            case TypeCode.Float -> Map.of("type", "number", "format", "float");
            case TypeCode.Double -> Map.of("type", "number", "format", "double");
            case TypeCode.DateTime -> Map.of("type", "string", "format", "date-time");
            case TypeCode.Boolean -> Map.of("type", "boolean");
            default -> Map.of("type", TypeConverter.toString(typeCode));
        };
    }

    private Map<String, Object> createResponsesData() {
        return Map.of("200", Map.of("description", "Successful response", "content", Map.of("application/json", Map.of("schema", Map.of("type", "object")))));
    }

    protected void writeData(int indent, Map<String, Object> data) {
        for (Map.Entry<String, Object> entry : data.entrySet()) {
            String key = entry.getKey();
            Object value = entry.getValue();
            if (value == null || value instanceof String && value.equals("null") || value instanceof Map && ((Map)value).values().stream().allMatch(v -> v.equals("null"))) continue;
            if (value instanceof String) {
                this.writeAsString(indent, key, (String)value);
                continue;
            }
            if (value instanceof List) {
                if (((List)value).isEmpty()) continue;
                this.writeName(indent, key);
                for (int index = 0; index < ((List)value).size(); ++index) {
                    Object item = ((List)value).get(index);
                    this.writeArrayItem(indent + 1, (String)item, null);
                }
                continue;
            }
            if (value instanceof Map) {
                Stream<Map.Entry> props = PropertyReflector.getProperties(value).entrySet().stream().filter(Objects::nonNull);
                if (props.toArray().length < 0) continue;
                this.writeName(indent, key);
                this.writeData(indent + 1, (Map)value);
                continue;
            }
            this.writeAsObject(indent, key, value);
        }
    }

    protected void writeName(int indent, String name) {
        String spaces = this.getSpaces(indent);
        this.content = this.content + spaces + name + ":\n";
    }

    protected void writeArrayItem(int indent, String name, Boolean isObjectItem) {
        isObjectItem = isObjectItem != null ? isObjectItem : false;
        String spaces = this.getSpaces(indent);
        this.content = this.content + spaces + "- ";
        this.content = isObjectItem != false ? this.content + name + ":\n" : this.content + name + "\n";
    }

    protected void writeAsObject(int indent, String name, Object value) {
        if (value == null) {
            return;
        }
        String spaces = this.getSpaces(indent);
        this.content = this.content + spaces + name + ": " + value + "\n";
    }

    protected void writeAsString(int indent, String name, String value) {
        if (value == null) {
            return;
        }
        String spaces = this.getSpaces(indent);
        this.content = this.content + spaces + name + ": '" + value + "'\n";
    }

    protected String getSpaces(int length) {
        return " ".repeat(Math.max(0, length * 2));
    }
}

