/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.expressions.variants;

import java.util.List;
import java.util.Objects;
import org.pipservices4.expressions.variants.IVariantOperations;
import org.pipservices4.expressions.variants.Variant;
import org.pipservices4.expressions.variants.VariantType;

public abstract class AbstractVariantOperations
implements IVariantOperations {
    protected String typeToString(VariantType value) {
        return switch (value) {
            case VariantType.Null -> "Null";
            case VariantType.Integer -> "Integer";
            case VariantType.Long -> "Long";
            case VariantType.Float -> "Float";
            case VariantType.Double -> "Double";
            case VariantType.String -> "String";
            case VariantType.Boolean -> "Boolean";
            case VariantType.DateTime -> "DateTime";
            case VariantType.TimeSpan -> "TimeSpan";
            case VariantType.Object -> "Object";
            case VariantType.Array -> "Array";
            default -> "Unknown";
        };
    }

    @Override
    public abstract Variant convert(Variant var1, VariantType var2);

    @Override
    public Variant add(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsInteger(value1.getAsInteger() + value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsLong(value1.getAsLong() + value2.getAsLong());
                return result;
            }
            case Float: {
                result.setAsFloat(Float.valueOf(value1.getAsFloat().floatValue() + value2.getAsFloat().floatValue()));
                return result;
            }
            case Double: {
                result.setAsDouble(value1.getAsDouble() + value2.getAsDouble());
                return result;
            }
            case TimeSpan: {
                result.setAsTimeSpan(value1.getAsTimeSpan() + value2.getAsTimeSpan());
                return result;
            }
            case String: {
                result.setAsString(value1.getAsString() + value2.getAsString());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '+' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant sub(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsInteger(value1.getAsInteger() - value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsLong(value1.getAsLong() - value2.getAsLong());
                return result;
            }
            case Float: {
                result.setAsFloat(Float.valueOf(value1.getAsFloat().floatValue() - value2.getAsFloat().floatValue()));
                return result;
            }
            case Double: {
                result.setAsDouble(value1.getAsDouble() - value2.getAsDouble());
                return result;
            }
            case TimeSpan: {
                result.setAsTimeSpan(value1.getAsTimeSpan() - value2.getAsTimeSpan());
                return result;
            }
            case DateTime: {
                result.setAsTimeSpan(value1.getAsDateTime().toInstant().toEpochMilli() - value2.getAsDateTime().toInstant().toEpochMilli());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '-' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant mul(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsInteger(value1.getAsInteger() * value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsLong(value1.getAsLong() * value2.getAsLong());
                return result;
            }
            case Float: {
                result.setAsFloat(Float.valueOf(value1.getAsFloat().floatValue() * value2.getAsFloat().floatValue()));
                return result;
            }
            case Double: {
                result.setAsDouble(value1.getAsDouble() * value2.getAsDouble());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '*' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant div(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsInteger(value1.getAsInteger() / value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsLong(value1.getAsLong() / value2.getAsLong());
                return result;
            }
            case Float: {
                result.setAsFloat(Float.valueOf(value1.getAsFloat().floatValue() / value2.getAsFloat().floatValue()));
                return result;
            }
            case Double: {
                result.setAsDouble(value1.getAsDouble() / value2.getAsDouble());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '/' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant mod(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsInteger(value1.getAsInteger() % value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsLong(value1.getAsLong() % value2.getAsLong());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '%' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant pow(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        switch (value1.getType()) {
            case Integer: 
            case Long: 
            case Float: 
            case Double: {
                value1 = this.convert(value1, VariantType.Double);
                value2 = this.convert(value2, VariantType.Double);
                result.setAsDouble(value1.getAsDouble() * value2.getAsDouble());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '^' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant and(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsInteger(value1.getAsInteger() & value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsLong(value1.getAsLong() & value2.getAsLong());
                return result;
            }
            case Boolean: {
                result.setAsBoolean(value1.getAsBoolean() != false && value2.getAsBoolean() != false);
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation AND is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant or(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsInteger(value1.getAsInteger() | value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsLong(value1.getAsLong() | value2.getAsLong());
                return result;
            }
            case Boolean: {
                result.setAsBoolean(value1.getAsBoolean() != false || value2.getAsBoolean() != false);
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation OR is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant xor(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsInteger(value1.getAsInteger() ^ value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsLong(value1.getAsLong() ^ value2.getAsLong());
                return result;
            }
            case Boolean: {
                result.setAsBoolean(value1.getAsBoolean() != false && value2.getAsBoolean() == false || value1.getAsBoolean() == false && value2.getAsBoolean() != false);
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation XOR is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant lsh(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, VariantType.Integer);
        switch (value1.getType()) {
            case Integer: {
                result.setAsInteger(value1.getAsInteger() << value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsLong(value1.getAsLong() << value2.getAsInteger());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '<<' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant rsh(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, VariantType.Integer);
        switch (value1.getType()) {
            case Integer: {
                result.setAsInteger(value1.getAsInteger() >> value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsLong(value1.getAsLong() >> value2.getAsInteger());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '>>' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant not(Variant value) {
        Variant result = new Variant();
        if (value.getType() == VariantType.Null) {
            return result;
        }
        switch (value.getType()) {
            case Integer: {
                result.setAsInteger(~value.getAsInteger().intValue());
                return result;
            }
            case Long: {
                result.setAsLong(value.getAsLong() ^ 0xFFFFFFFFFFFFFFFFL);
                return result;
            }
            case Boolean: {
                result.setAsBoolean(value.getAsBoolean() == false);
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation NOT is not supported for type " + this.typeToString(value.getType()));
    }

    @Override
    public Variant negative(Variant value) {
        Variant result = new Variant();
        if (value.getType() == VariantType.Null) {
            return result;
        }
        switch (value.getType()) {
            case Integer: {
                result.setAsInteger(-value.getAsInteger().intValue());
                return result;
            }
            case Long: {
                result.setAsLong(-value.getAsLong().longValue());
                return result;
            }
            case Float: {
                result.setAsFloat(Float.valueOf(-value.getAsFloat().floatValue()));
                return result;
            }
            case Double: {
                result.setAsDouble(-value.getAsDouble().doubleValue());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation unary '-' is not supported for type " + this.typeToString(value.getType()));
    }

    @Override
    public Variant equal(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null && value2.getType() == VariantType.Null) {
            result.setAsBoolean(true);
            return result;
        }
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            result.setAsBoolean(false);
            return result;
        }
        List<VariantType> numericTypes = List.of(VariantType.Integer, VariantType.Long, VariantType.Float, VariantType.Double);
        boolean isNumeric = numericTypes.contains((Object)value1.getType()) || numericTypes.contains((Object)value2.getType());
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsBoolean(Objects.equals(value1.getAsInteger(), value2.getAsInteger()));
                return result;
            }
            case Long: {
                result.setAsBoolean(Objects.equals(value1.getAsLong(), value2.getAsLong()));
                return result;
            }
            case Float: {
                result.setAsBoolean(Objects.equals(value1.getAsFloat(), value2.getAsFloat()));
                return result;
            }
            case Double: {
                result.setAsBoolean(Objects.equals(value1.getAsDouble(), value2.getAsDouble()));
                return result;
            }
            case String: {
                if (isNumeric) {
                    value1.setAsString(value1.getAsString().replaceAll(".0+$", ""));
                    value2.setAsString(value2.getAsString().replaceAll(".0+$", ""));
                }
                result.setAsBoolean(Objects.equals(value1.getAsString(), value2.getAsString()));
                return result;
            }
            case TimeSpan: {
                result.setAsBoolean(Objects.equals(value1.getAsTimeSpan(), value2.getAsTimeSpan()));
                return result;
            }
            case DateTime: {
                result.setAsBoolean(value1.getAsDateTime().toInstant().toEpochMilli() == value2.getAsDateTime().toInstant().toEpochMilli());
                return result;
            }
            case Boolean: {
                result.setAsBoolean(value1.getAsBoolean() == value2.getAsBoolean());
                return result;
            }
            case Object: {
                result.setAsObject(value1.getAsObject() == value2.getAsObject());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '=' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant notEqual(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null && value2.getType() == VariantType.Null) {
            result.setAsBoolean(false);
            return result;
        }
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            result.setAsBoolean(true);
            return result;
        }
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsBoolean(!Objects.equals(value1.getAsInteger(), value2.getAsInteger()));
                return result;
            }
            case Long: {
                result.setAsBoolean(!Objects.equals(value1.getAsLong(), value2.getAsLong()));
                return result;
            }
            case Float: {
                result.setAsBoolean(!Objects.equals(value1.getAsFloat(), value2.getAsFloat()));
                return result;
            }
            case Double: {
                result.setAsBoolean(!Objects.equals(value1.getAsDouble(), value2.getAsDouble()));
                return result;
            }
            case String: {
                result.setAsBoolean(!Objects.equals(value1.getAsString(), value2.getAsString()));
                return result;
            }
            case TimeSpan: {
                result.setAsBoolean(!Objects.equals(value1.getAsTimeSpan(), value2.getAsTimeSpan()));
                return result;
            }
            case DateTime: {
                result.setAsBoolean(value1.getAsDateTime().toInstant().toEpochMilli() != value2.getAsDateTime().toInstant().toEpochMilli());
                return result;
            }
            case Boolean: {
                result.setAsBoolean(value1.getAsBoolean() != value2.getAsBoolean());
                return result;
            }
            case Object: {
                result.setAsObject(value1.getAsObject() != value2.getAsObject());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '<>' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant more(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsBoolean(value1.getAsInteger() > value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsBoolean(value1.getAsLong() > value2.getAsLong());
                return result;
            }
            case Float: {
                result.setAsBoolean(value1.getAsFloat().floatValue() > value2.getAsFloat().floatValue());
                return result;
            }
            case Double: {
                result.setAsBoolean(value1.getAsDouble() > value2.getAsDouble());
                return result;
            }
            case String: {
                result.setAsBoolean(value1.getAsString().charAt(0) > value2.getAsString().charAt(0));
                return result;
            }
            case TimeSpan: {
                result.setAsBoolean(value1.getAsTimeSpan() > value2.getAsTimeSpan());
                return result;
            }
            case DateTime: {
                result.setAsBoolean(value1.getAsDateTime().toInstant().toEpochMilli() > value2.getAsDateTime().toInstant().toEpochMilli());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '>' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant less(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsBoolean(value1.getAsInteger() < value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsBoolean(value1.getAsLong() < value2.getAsLong());
                return result;
            }
            case Float: {
                result.setAsBoolean(value1.getAsFloat().floatValue() < value2.getAsFloat().floatValue());
                return result;
            }
            case Double: {
                result.setAsBoolean(value1.getAsDouble() < value2.getAsDouble());
                return result;
            }
            case String: {
                result.setAsBoolean(value1.getAsString().charAt(0) < value2.getAsString().charAt(0));
                return result;
            }
            case TimeSpan: {
                result.setAsBoolean(value1.getAsTimeSpan() < value2.getAsTimeSpan());
                return result;
            }
            case DateTime: {
                result.setAsBoolean(value1.getAsDateTime().toInstant().toEpochMilli() < value2.getAsDateTime().toInstant().toEpochMilli());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '<' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant moreEqual(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsBoolean(value1.getAsInteger() >= value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsBoolean(value1.getAsLong() >= value2.getAsLong());
                return result;
            }
            case Float: {
                result.setAsBoolean(value1.getAsFloat().floatValue() >= value2.getAsFloat().floatValue());
                return result;
            }
            case Double: {
                result.setAsBoolean(value1.getAsDouble() >= value2.getAsDouble());
                return result;
            }
            case String: {
                result.setAsBoolean(value1.getAsString().charAt(0) >= value2.getAsString().charAt(0));
                return result;
            }
            case TimeSpan: {
                result.setAsBoolean(value1.getAsTimeSpan() >= value2.getAsTimeSpan());
                return result;
            }
            case DateTime: {
                result.setAsBoolean(value1.getAsDateTime().toInstant().toEpochMilli() >= value2.getAsDateTime().toInstant().toEpochMilli());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '>=' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant lessEqual(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, value1.getType());
        switch (value1.getType()) {
            case Integer: {
                result.setAsBoolean(value1.getAsInteger() <= value2.getAsInteger());
                return result;
            }
            case Long: {
                result.setAsBoolean(value1.getAsLong() <= value2.getAsLong());
                return result;
            }
            case Float: {
                result.setAsBoolean(value1.getAsFloat().floatValue() <= value2.getAsFloat().floatValue());
                return result;
            }
            case Double: {
                result.setAsBoolean(value1.getAsDouble() <= value2.getAsDouble());
                return result;
            }
            case String: {
                result.setAsBoolean(value1.getAsString().charAt(0) <= value2.getAsString().charAt(0));
                return result;
            }
            case TimeSpan: {
                result.setAsBoolean(value1.getAsTimeSpan() <= value2.getAsTimeSpan());
                return result;
            }
            case DateTime: {
                result.setAsBoolean(value1.getAsDateTime().toInstant().toEpochMilli() <= value2.getAsDateTime().toInstant().toEpochMilli());
                return result;
            }
        }
        throw new UnsupportedOperationException("Operation '<=' is not supported for type " + this.typeToString(value1.getType()));
    }

    @Override
    public Variant in(Variant value1, Variant value2) {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        if (value1.getAsObject() == null) {
            result.setAsBoolean(false);
            return result;
        }
        if (value1.getType() == VariantType.Array) {
            List<Variant> array = value1.getAsArray();
            for (Variant element : array) {
                Variant eq = this.equal(value2, element);
                if (eq.getType() != VariantType.Boolean || !eq.getAsBoolean().booleanValue()) continue;
                result.setAsBoolean(true);
                return result;
            }
            result.setAsBoolean(false);
            return result;
        }
        return this.equal(value1, value2);
    }

    @Override
    public Variant getElement(Variant value1, Variant value2) throws Exception {
        Variant result = new Variant();
        if (value1.getType() == VariantType.Null || value2.getType() == VariantType.Null) {
            return result;
        }
        value2 = this.convert(value2, VariantType.Integer);
        if (value1.getType() == VariantType.Array) {
            return value1.getByIndex(value2.getAsInteger());
        }
        if (value1.getType() == VariantType.String) {
            result.setAsString(String.valueOf(value1.getAsString().charAt(value2.getAsInteger())));
            return result;
        }
        throw new UnsupportedOperationException("Operation '[]' is not supported for type " + this.typeToString(value1.getType()));
    }
}

