/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.expressions.tokenizers.generic;

import java.security.InvalidParameterException;
import org.pipservices4.expressions.io.IScanner;
import org.pipservices4.expressions.tokenizers.ITokenizer;
import org.pipservices4.expressions.tokenizers.Token;
import org.pipservices4.expressions.tokenizers.TokenType;
import org.pipservices4.expressions.tokenizers.generic.GenericCommentState;
import org.pipservices4.expressions.tokenizers.utilities.CharValidator;

public class CppCommentState
extends GenericCommentState {
    protected final int STAR = 42;
    protected final int SLASH = 47;

    protected String getMultiLineComment(IScanner scanner) {
        StringBuilder result = new StringBuilder();
        int lastSymbol = 0;
        int nextSymbol = scanner.read();
        while (!CharValidator.isEof(nextSymbol)) {
            result.append((char)nextSymbol);
            if (lastSymbol == this.STAR && nextSymbol == this.SLASH) break;
            lastSymbol = nextSymbol;
            nextSymbol = scanner.read();
        }
        return result.toString();
    }

    protected String getSingleLineComment(IScanner scanner) {
        StringBuilder result = new StringBuilder();
        int nextSymbol = scanner.read();
        while (!CharValidator.isEof(nextSymbol) && !CharValidator.isEol(nextSymbol)) {
            result.append((char)nextSymbol);
            nextSymbol = scanner.read();
        }
        if (CharValidator.isEol(nextSymbol)) {
            scanner.unread();
        }
        return result.toString();
    }

    @Override
    public Token nextToken(IScanner scanner, ITokenizer tokenizer) throws Exception {
        int firstSymbol = scanner.read();
        int line = scanner.line();
        int column = scanner.column();
        if (firstSymbol != this.SLASH) {
            scanner.unread();
            throw new InvalidParameterException("Incorrect usage of CppCommentState.");
        }
        int secondSymbol = scanner.read();
        if (secondSymbol == this.STAR) {
            return new Token(TokenType.Comment, "/*" + this.getMultiLineComment(scanner), line, column);
        }
        if (secondSymbol == this.SLASH) {
            return new Token(TokenType.Comment, "//" + this.getSingleLineComment(scanner), line, column);
        }
        if (!CharValidator.isEof(secondSymbol)) {
            scanner.unread();
        }
        if (!CharValidator.isEof(firstSymbol)) {
            scanner.unread();
        }
        return tokenizer.getSymbolState().nextToken(scanner, tokenizer);
    }
}

