/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.expressions.csv;

import org.pipservices4.expressions.io.IScanner;
import org.pipservices4.expressions.tokenizers.ITokenizer;
import org.pipservices4.expressions.tokenizers.Token;
import org.pipservices4.expressions.tokenizers.TokenType;
import org.pipservices4.expressions.tokenizers.generic.GenericSymbolState;

public class CsvSymbolState
extends GenericSymbolState {
    public CsvSymbolState() throws Exception {
        this.add("\n", TokenType.Eol);
        this.add("\r", TokenType.Eol);
        this.add("\r\n", TokenType.Eol);
        this.add("\n\r", TokenType.Eol);
    }

    @Override
    public Token nextToken(IScanner scanner, ITokenizer tokenizer) throws Exception {
        int nextSymbol = scanner.read();
        int line = scanner.line();
        int column = scanner.column();
        if (nextSymbol != 10 && nextSymbol != 13) {
            return new Token(TokenType.Symbol, String.valueOf((char)nextSymbol), line, column);
        }
        scanner.unread();
        return super.nextToken(scanner, tokenizer);
    }
}

