/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.expressions.calculator.tokenizers;

import org.pipservices4.expressions.io.IScanner;
import org.pipservices4.expressions.tokenizers.IQuoteState;
import org.pipservices4.expressions.tokenizers.ITokenizer;
import org.pipservices4.expressions.tokenizers.Token;
import org.pipservices4.expressions.tokenizers.TokenType;
import org.pipservices4.expressions.tokenizers.utilities.CharValidator;

public class ExpressionQuoteState
implements IQuoteState {
    protected final int QUOTE = 34;

    @Override
    public Token nextToken(IScanner scanner, ITokenizer tokenizer) throws Exception {
        int firstSymbol = scanner.read();
        int line = scanner.line();
        int column = scanner.column();
        StringBuilder tokenValue = new StringBuilder();
        tokenValue.append((char)firstSymbol);
        int nextSymbol = scanner.read();
        while (!CharValidator.isEof(nextSymbol)) {
            tokenValue.append((char)nextSymbol);
            if (nextSymbol == firstSymbol) {
                if (scanner.peek() != firstSymbol) break;
                nextSymbol = scanner.read();
                tokenValue.append((char)nextSymbol);
            }
            nextSymbol = scanner.read();
        }
        return new Token(firstSymbol == this.QUOTE ? TokenType.Word : TokenType.Quoted, tokenValue.toString(), line, column);
    }

    @Override
    public String encodeString(String value, int quoteSymbol) {
        if (value == null) {
            return null;
        }
        String quoteString = String.valueOf((char)quoteSymbol);
        return quoteString + value.replace(quoteString, quoteString + quoteString) + quoteString;
    }

    @Override
    public String decodeString(String value, int quoteSymbol) {
        if (value == null) {
            return null;
        }
        if (value.length() >= 2 && value.codePointAt(0) == quoteSymbol && value.codePointAt(value.length() - 1) == quoteSymbol) {
            String quoteString = String.valueOf((char)quoteSymbol);
            return value.substring(1, value.length() - 1).replace(quoteString + quoteString, quoteString);
        }
        return value;
    }
}

