/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.expressions.calculator.tokenizers;

import java.util.Objects;
import org.pipservices4.expressions.io.IScanner;
import org.pipservices4.expressions.tokenizers.ITokenizer;
import org.pipservices4.expressions.tokenizers.Token;
import org.pipservices4.expressions.tokenizers.TokenType;
import org.pipservices4.expressions.tokenizers.generic.GenericNumberState;
import org.pipservices4.expressions.tokenizers.utilities.CharValidator;

public class ExpressionNumberState
extends GenericNumberState {
    protected final int PLUS = 43;
    protected final int EXP1 = 101;
    protected final int EXP2 = 69;

    @Override
    public Token nextToken(IScanner scanner, ITokenizer tokenizer) throws Exception {
        int line = scanner.peekLine();
        int column = scanner.peekColumn();
        int n = scanner.peek();
        Objects.requireNonNull(this);
        if (n == 45) {
            return tokenizer.getSymbolState().nextToken(scanner, tokenizer);
        }
        Token token = super.nextToken(scanner, tokenizer);
        if (token.getType() != TokenType.Integer && token.getType() != TokenType.Float) {
            return token;
        }
        int nextChar = scanner.peek();
        if (nextChar != this.EXP1 && nextChar != this.EXP2) {
            return token;
        }
        StringBuilder tokenValue = new StringBuilder(String.valueOf((char)scanner.read()));
        nextChar = scanner.peek();
        Objects.requireNonNull(this);
        if (nextChar == 45 || nextChar == this.PLUS) {
            tokenValue.append((char)scanner.read());
            nextChar = scanner.peek();
        }
        if (!CharValidator.isDigit(nextChar)) {
            scanner.unreadMany(tokenValue.length());
            return token;
        }
        while (CharValidator.isDigit(nextChar)) {
            tokenValue.append((char)scanner.read());
            nextChar = scanner.peek();
        }
        return new Token(TokenType.Float, token.getValue() + tokenValue, line, column);
    }
}

