/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.validate;

import java.util.List;
import org.pipservices4.commons.reflect.ObjectReader;
import org.pipservices4.data.validate.IValidationRule;
import org.pipservices4.data.validate.ObjectComparator;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.data.validate.ValidationResult;
import org.pipservices4.data.validate.ValidationResultType;

public class PropertiesComparisonRule
implements IValidationRule {
    private final String _property1;
    private final String _property2;
    private final String _operation;

    public PropertiesComparisonRule(String property1, String operation, String property2) {
        this._property1 = property1;
        this._operation = operation;
        this._property2 = property2;
    }

    @Override
    public void validate(String path, Schema schema, Object value, List<ValidationResult> results) {
        Object value2;
        String name = path != null ? path : "value";
        Object value1 = ObjectReader.getProperty(value, this._property1);
        if (!ObjectComparator.compare(value1, this._operation, value2 = ObjectReader.getProperty(value, this._property2))) {
            results.add(new ValidationResult(path, ValidationResultType.Error, "PROPERTIES_NOT_MATCH", name + " must have " + this._property1 + " " + this._operation + " " + this._property2, value2, value1));
        }
    }
}

