/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.validate;

import java.util.ArrayList;
import java.util.List;
import org.pipservices4.data.validate.IValidationRule;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.data.validate.ValidationResult;

public class OrRule
implements IValidationRule {
    private final IValidationRule[] _rules;

    public OrRule(IValidationRule ... rules) {
        this._rules = rules;
    }

    @Override
    public void validate(String path, Schema schema, Object value, List<ValidationResult> results) {
        if (this._rules == null || this._rules.length == 0) {
            return;
        }
        ArrayList<ValidationResult> localResults = new ArrayList<ValidationResult>();
        for (IValidationRule rule : this._rules) {
            int resultsCount = localResults.size();
            rule.validate(path, schema, value, localResults);
            if (resultsCount != localResults.size()) continue;
            return;
        }
        results.addAll(localResults);
    }
}

