/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.validate;

import java.util.ArrayList;
import java.util.List;
import org.pipservices4.data.validate.IValidationRule;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.data.validate.ValidationResult;
import org.pipservices4.data.validate.ValidationResultType;

public class NotRule
implements IValidationRule {
    private final IValidationRule _rule;

    public NotRule(IValidationRule rule) {
        this._rule = rule;
    }

    @Override
    public void validate(String path, Schema schema, Object value, List<ValidationResult> results) {
        if (this._rule == null) {
            return;
        }
        String name = path != null ? path : "value";
        ArrayList<ValidationResult> localResults = new ArrayList<ValidationResult>();
        this._rule.validate(path, schema, value, localResults);
        if (!localResults.isEmpty()) {
            return;
        }
        results.add(new ValidationResult(path, ValidationResultType.Error, "NOT_FAILED", "Negative check for " + name + " failed", null, null));
    }
}

