/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.validate;

import java.util.Arrays;
import java.util.List;
import org.pipservices4.data.validate.IValidationRule;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.data.validate.ValidationResult;
import org.pipservices4.data.validate.ValidationResultType;

public class IncludedRule
implements IValidationRule {
    private final Object[] _values;

    public IncludedRule(Object ... values) {
        this._values = values;
    }

    @Override
    public void validate(String path, Schema schema, Object value, List<ValidationResult> results) {
        String name = path != null ? path : "value";
        boolean found = false;
        for (Object thisValue : this._values) {
            if (thisValue == null || !thisValue.equals(value)) continue;
            found = true;
            break;
        }
        if (!found) {
            results.add(new ValidationResult(path, ValidationResultType.Error, "VALUE_NOT_INCLUDED", name + " must be one of " + Arrays.toString(this._values), this._values, value));
        }
    }
}

