/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.random;

import java.util.Arrays;
import java.util.stream.Stream;
import org.pipservices4.data.random.RandomBoolean;
import org.pipservices4.data.random.RandomInteger;
import org.pipservices4.data.random.RandomString;

public class RandomText {
    private static final String[] _namePrefixes = new String[]{"Dr.", "Mr.", "Mrs"};
    private static final String[] _nameSuffixes = new String[]{"Jr.", "Sr.", "II", "III"};
    private static final String[] _firstNames = new String[]{"John", "Bill", "Andrew", "Nick", "Pamela", "Bela", "Sergio", "George", "Hurry", "Cecilia", "Vesta", "Terry", "Patrick"};
    private static final String[] _lastNames = new String[]{"Doe", "Smith", "Johns", "Gates", "Carmack", "Zontak", "Clinton", "Adams", "First", "Lopez", "Due", "White", "Black"};
    private static final String[] _colors = new String[]{"Black", "White", "Red", "Blue", "Green", "Yellow", "Purple", "Grey", "Magenta", "Cian"};
    private static final String[] _stuffs = new String[]{"Game", "Ball", "Home", "Board", "Car", "Plane", "Hotel", "Wine", "Pants", "Boots", "Table", "Chair"};
    private static final String[] _adjectives = new String[]{"Large", "Small", "High", "Low", "Certain", "Fuzzy", "Modern", "Faster", "Slower"};
    private static final String[] _verbs = new String[]{"Run", "Stay", "Breeze", "Fly", "Lay", "Write", "Draw", "Scream"};
    private static final String[] _allWords = (String[])Stream.concat(Stream.concat(Stream.concat(Arrays.stream(_firstNames), Arrays.stream(_lastNames)), Stream.concat(Arrays.stream(_colors), Arrays.stream(_stuffs))), Stream.concat(Arrays.stream(_adjectives), Arrays.stream(_verbs))).toArray(String[]::new);

    public static String color() {
        return RandomString.pick(_colors);
    }

    public static String noun() {
        return RandomString.pick(_stuffs);
    }

    public static String adjective() {
        return RandomString.pick(_adjectives);
    }

    public static String verb() {
        return RandomString.pick(_verbs);
    }

    public static String phrase(int size) {
        return RandomText.phrase(size, size);
    }

    public static String phrase(int minSize, int maxSize) {
        int size = RandomInteger.nextInteger(minSize, maxSize = Math.max(minSize, maxSize));
        if (size <= 0) {
            return "";
        }
        StringBuilder result = new StringBuilder();
        result.append(RandomString.pick(_allWords));
        while (result.length() < size) {
            result.append(" ").append(RandomString.pick(_allWords).toLowerCase());
        }
        return result.toString();
    }

    public static String fullName() {
        StringBuilder result = new StringBuilder();
        if (RandomBoolean.chance(3.0f, 5.0f)) {
            result.append(RandomString.pick(_namePrefixes)).append(" ");
        }
        result.append(RandomString.pick(_firstNames)).append(" ").append(RandomString.pick(_lastNames));
        if (RandomBoolean.chance(5.0f, 10.0f)) {
            result.append(" ").append(RandomString.pick(_nameSuffixes));
        }
        return result.toString();
    }

    public static String word() {
        return RandomString.pick(_allWords);
    }

    public static String words(int min, int max) {
        StringBuilder result = new StringBuilder();
        int count = RandomInteger.nextInteger(min, max);
        for (int i = 0; i < count; ++i) {
            result.append(RandomString.pick(_allWords));
        }
        return result.toString();
    }

    public static String phone() {
        return "(" + RandomInteger.nextInteger(111, 999) + ") " + RandomInteger.nextInteger(111, 999) + "-" + RandomInteger.nextInteger(0, 9999);
    }

    public static String email() {
        return RandomText.words(2, 6) + "@" + RandomText.words(1, 3) + ".com";
    }

    public static String text(int minSize, int maxSize) {
        maxSize = Math.max(minSize, maxSize);
        int size = RandomInteger.nextInteger(minSize, maxSize);
        StringBuilder result = new StringBuilder();
        result.append(RandomString.pick(_allWords));
        while (result.length() < size) {
            Object next = RandomString.pick(_allWords);
            next = RandomBoolean.chance(4.0f, 6.0f) ? " " + ((String)next).toLowerCase() : (RandomBoolean.chance(2.0f, 5.0f) ? RandomString.pickChar(":,-") + ((String)next).toLowerCase() : (RandomBoolean.chance(3.0f, 5.0f) ? RandomString.pickChar(":,-") + " " + ((String)next).toLowerCase() : RandomString.pickChar(".!?") + " " + (String)next));
            result.append((String)next);
        }
        return result.toString();
    }
}

