/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.config.connect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.config.connect.ConnectionParams;
import org.pipservices4.config.connect.IDiscovery;

public class ConnectionResolver
implements IConfigurable,
IReferenceable {
    private final List<ConnectionParams> _connections = new ArrayList<ConnectionParams>();
    private IReferences _references = null;

    public ConnectionResolver() {
    }

    public ConnectionResolver(ConfigParams config) {
        this.configure(config);
    }

    public ConnectionResolver(ConfigParams config, IReferences references) {
        if (config != null) {
            this.configure(config);
        }
        if (references != null) {
            this.setReferences(references);
        }
    }

    public void configure(ConfigParams config, boolean configAsDefault) {
        this._connections.addAll(ConnectionParams.manyFromConfig(config, configAsDefault));
    }

    @Override
    public void configure(ConfigParams config) {
        this.configure(config, false);
    }

    @Override
    public void setReferences(IReferences references) {
        this._references = references;
    }

    public List<ConnectionParams> getAll() {
        return this._connections;
    }

    public void add(ConnectionParams connection) {
        this._connections.add(connection);
    }

    private boolean registerInDiscovery(IContext context, ConnectionParams connection) throws ApplicationException {
        if (!connection.useDiscovery()) {
            return false;
        }
        String key = connection.getDiscoveryKey();
        if (this._references == null) {
            return false;
        }
        List<Object> components = this._references.getOptional(new Descriptor("*", "discovery", "*", "*", "*"));
        if (components == null) {
            return false;
        }
        for (Object component : components) {
            if (!(component instanceof IDiscovery)) continue;
            ((IDiscovery)component).register(context, key, connection);
        }
        return true;
    }

    public void register(IContext context, ConnectionParams connection) throws ApplicationException {
        boolean result = this.registerInDiscovery(context, connection);
        if (result) {
            this._connections.add(connection);
        }
    }

    private ConnectionParams resolveInDiscovery(IContext context, ConnectionParams connection) throws ApplicationException {
        if (!connection.useDiscovery()) {
            return null;
        }
        String key = connection.getDiscoveryKey();
        if (this._references == null) {
            return null;
        }
        Descriptor discoveryDescriptor = new Descriptor("*", "discovery", "*", "*", "*");
        List<Object> components = this._references.getOptional(discoveryDescriptor);
        if (components.isEmpty()) {
            throw new ReferenceException(context, discoveryDescriptor);
        }
        for (Object component : components) {
            ConnectionParams resolvedConnection;
            if (!(component instanceof IDiscovery) || (resolvedConnection = ((IDiscovery)component).resolveOne(context, key)) == null) continue;
            return resolvedConnection;
        }
        return null;
    }

    public ConnectionParams resolve(IContext context) throws ApplicationException {
        if (this._connections.isEmpty()) {
            return null;
        }
        for (ConnectionParams connection : this._connections) {
            if (connection.useDiscovery()) continue;
            return connection;
        }
        for (ConnectionParams connection : this._connections) {
            ConnectionParams resolvedConnection;
            if (!connection.useDiscovery() || (resolvedConnection = this.resolveInDiscovery(context, connection)) == null) continue;
            resolvedConnection = new ConnectionParams((Map<?, ?>)ConfigParams.mergeConfigs(connection, resolvedConnection));
            return resolvedConnection;
        }
        return null;
    }

    private List<ConnectionParams> resolveAllInDiscovery(IContext context, ConnectionParams connection) throws ApplicationException {
        ArrayList<ConnectionParams> result = new ArrayList<ConnectionParams>();
        if (!connection.useDiscovery()) {
            return result;
        }
        String key = connection.getDiscoveryKey();
        if (this._references == null) {
            return result;
        }
        Descriptor discoveryDescriptor = new Descriptor("*", "discovery", "*", "*", "*");
        List<Object> components = this._references.getOptional(new Descriptor("*", "discovery", "*", "*", "*"));
        if (components.isEmpty()) {
            throw new ReferenceException(context, discoveryDescriptor);
        }
        for (Object component : components) {
            List<ConnectionParams> resolvedConnections;
            if (!(component instanceof IDiscovery) || (resolvedConnections = ((IDiscovery)component).resolveAll(context, key)) == null) continue;
            result.addAll(resolvedConnections);
        }
        return result;
    }

    public List<ConnectionParams> resolveAll(IContext context) throws ApplicationException {
        ArrayList<ConnectionParams> resolved = new ArrayList<ConnectionParams>();
        ArrayList<ConnectionParams> toResolve = new ArrayList<ConnectionParams>();
        for (ConnectionParams connection : this._connections) {
            if (connection.useDiscovery()) {
                toResolve.add(connection);
                continue;
            }
            resolved.add(connection);
        }
        if (!toResolve.isEmpty()) {
            for (ConnectionParams connection : toResolve) {
                List<ConnectionParams> results = this.resolveAllInDiscovery(context, connection);
                for (ConnectionParams result : results) {
                    ConnectionParams localResolvedConnection = new ConnectionParams((Map<?, ?>)ConfigParams.mergeConfigs(connection, result));
                    resolved.add(localResolvedConnection);
                }
            }
        }
        return resolved;
    }
}

