/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.config.connect;

import java.util.ArrayList;
import java.util.List;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.config.auth.CredentialParams;
import org.pipservices4.config.auth.CredentialResolver;
import org.pipservices4.config.connect.ConnectionParams;
import org.pipservices4.config.connect.ConnectionResolver;

public class CompositeConnectionResolver
implements IReferenceable,
IConfigurable {
    protected ConfigParams _options;
    protected ConnectionResolver _connectionResolver = new ConnectionResolver();
    protected CredentialResolver _credentialResolver = new CredentialResolver();
    protected boolean _clusterSupported = true;
    protected String _defaultProtocol = null;
    protected int _defaultPort = 0;
    List<String> _supportedProtocols = null;

    @Override
    public void configure(ConfigParams configParams) throws ConfigException {
        this._connectionResolver.configure(configParams);
        this._credentialResolver.configure(configParams);
        this._options = configParams.getSection("options");
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException, ConfigException {
        this._connectionResolver.setReferences(references);
        this._credentialResolver.setReferences(references);
    }

    public ConfigParams resolve(IContext context) throws ApplicationException {
        ArrayList<ConnectionParams> connections = this._connectionResolver.resolveAll(context);
        ArrayList<ConnectionParams> arrayList = connections = connections != null ? connections : new ArrayList<ConnectionParams>();
        if (!connections.isEmpty() && !this._clusterSupported) {
            throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "MULTIPLE_CONNECTIONS_NOT_SUPPORTED", "Multiple (cluster) connections are not supported");
        }
        for (ConnectionParams connection : connections) {
            this.validateConnection(context, connection);
        }
        CredentialParams credential = this._credentialResolver.lookup(context);
        credential = credential != null ? credential : new CredentialParams();
        this.validateCredential(context, credential);
        return this.composeOptions(connections, credential, this._options);
    }

    public ConfigParams compose(IContext context, List<ConnectionParams> connections, CredentialParams credential, ConfigParams parameters) throws ConfigException {
        for (ConnectionParams connection : connections) {
            this.validateConnection(context, connection);
        }
        this.validateCredential(context, credential);
        return this.composeOptions(connections, credential, parameters);
    }

    protected void validateConnection(IContext context, ConnectionParams connection) throws ConfigException {
        if (connection == null) {
            throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "NO_CONNECTION", "Connection parameters are not set is not set");
        }
        String uri = connection.getUri();
        if (uri != null) {
            return;
        }
        String protocol = connection.getProtocolWithDefault(this._defaultProtocol);
        if (protocol == null) {
            throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "NO_PROTOCOL", "Connection protocol is not set");
        }
        if (this._supportedProtocols != null && !this._supportedProtocols.contains(protocol)) {
            throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "UNSUPPORTED_PROTOCOL", "The protocol " + protocol + " is not supported");
        }
        String host = connection.getHost();
        if (host == null) {
            throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "NO_HOST", "Connection host is not set");
        }
        int port = connection.getPortWithDefault(this._defaultPort);
        if (port == 0) {
            throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "NO_PORT", "Connection port is not set");
        }
    }

    protected void validateCredential(IContext context, CredentialParams credential) {
    }

    private ConfigParams composeOptions(List<ConnectionParams> connections, CredentialParams credential, ConfigParams parameters) {
        ConfigParams options = new ConfigParams();
        for (ConnectionParams connection : connections) {
            options = this.mergeConnection(options, connection);
        }
        options = this.mergeCredential(options, credential);
        options = this.mergeOptional(options, parameters);
        options = this.finalizeOptions(options);
        return options;
    }

    protected ConfigParams mergeConnection(ConfigParams options, ConnectionParams connection) {
        return options.setDefaults(connection);
    }

    protected ConfigParams mergeCredential(ConfigParams options, CredentialParams credential) {
        return options.override(credential);
    }

    protected ConfigParams mergeOptional(ConfigParams options, ConfigParams parameters) {
        return options.setDefaults(parameters);
    }

    protected ConfigParams finalizeOptions(ConfigParams options) {
        return options;
    }
}

