/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.config.auth;

import java.util.ArrayList;
import java.util.List;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.config.auth.CredentialParams;
import org.pipservices4.config.auth.ICredentialStore;

public class CredentialResolver
implements IConfigurable,
IReferenceable {
    private final List<CredentialParams> _credentials = new ArrayList<CredentialParams>();
    private IReferences _references = null;

    public CredentialResolver() {
    }

    public CredentialResolver(ConfigParams config) {
        this.configure(config);
    }

    public CredentialResolver(ConfigParams config, IReferences references) {
        if (config != null) {
            this.configure(config);
        }
        if (references != null) {
            this.setReferences(references);
        }
    }

    public void configure(ConfigParams config, boolean configAsDefault) {
        this._credentials.addAll(CredentialParams.manyFromConfig(config, configAsDefault));
    }

    @Override
    public void configure(ConfigParams config) {
        this.configure(config, false);
    }

    @Override
    public void setReferences(IReferences references) {
        this._references = references;
    }

    public List<CredentialParams> getAll() {
        return this._credentials;
    }

    public void add(CredentialParams connection) {
        this._credentials.add(connection);
    }

    private CredentialParams lookupInStores(IContext context, CredentialParams credential) throws ApplicationException {
        if (!credential.useCredentialStore()) {
            return null;
        }
        String key = credential.getStoreKey();
        if (this._references == null) {
            return null;
        }
        List<Object> components = this._references.getOptional(new Descriptor("*", "credential_store", "*", "*", "*"));
        if (components.isEmpty()) {
            throw new ReferenceException(context, "Credential store wasn't found to make lookup");
        }
        for (Object component : components) {
            CredentialParams resolvedCredential;
            if (!(component instanceof ICredentialStore) || (resolvedCredential = ((ICredentialStore)component).lookup(context, key)) == null) continue;
            return resolvedCredential;
        }
        return null;
    }

    public CredentialParams lookup(IContext context) throws ApplicationException {
        if (this._credentials.isEmpty()) {
            return null;
        }
        for (CredentialParams credential : this._credentials) {
            if (credential.useCredentialStore()) continue;
            return credential;
        }
        for (CredentialParams credential : this._credentials) {
            CredentialParams resolvedConnection;
            if (!credential.useCredentialStore() || (resolvedConnection = this.lookupInStores(context, credential)) == null) continue;
            return resolvedConnection;
        }
        return null;
    }
}

