/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.config.auth;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import org.pipservices4.commons.data.StringValueMap;
import org.pipservices4.commons.reflect.RecursiveObjectReader;
import org.pipservices4.components.config.ConfigParams;

public class CredentialParams
extends ConfigParams {
    private static final long serialVersionUID = 4144579662501676747L;

    public CredentialParams() {
    }

    public CredentialParams(Map<?, ?> map) {
        super(map);
    }

    public boolean useCredentialStore() {
        return this.containsKey("store_key");
    }

    public String getStoreKey() {
        return this.getAsNullableString("store_key");
    }

    public void setStoreKey(String value) {
        this.put("store_key", value);
    }

    public String getUsername() {
        return this.getAsNullableString("user") != null ? this.getAsNullableString("user") : this.getAsNullableString("username");
    }

    public void setUsername(String value) {
        this.put("username", value);
    }

    public String getPassword() {
        return this.getAsNullableString("pass") != null ? this.getAsNullableString("pass") : this.getAsNullableString("password");
    }

    public void setPassword(String password) {
        this.put("password", password);
    }

    public String getAccessId() {
        String accessId = this.getAsNullableString("access_id");
        accessId = accessId != null ? accessId : this.getAsNullableString("client_id");
        return accessId;
    }

    public void setAccessId(String value) {
        this.put("access_id", value);
    }

    public String getAccessKey() {
        String accessKey = this.getAsNullableString("access_key");
        accessKey = accessKey != null ? accessKey : this.getAsNullableString("client_key");
        accessKey = accessKey != null ? accessKey : this.getAsNullableString("secret_key");
        return accessKey;
    }

    public void setAccessKey(String value) {
        this.put("access_key", value);
    }

    public static CredentialParams fromString(String line) {
        StringValueMap map = StringValueMap.fromString(line);
        return new CredentialParams((Map<?, ?>)map);
    }

    public static List<CredentialParams> manyFromConfig(ConfigParams config, boolean configAsDefault) {
        ArrayList<CredentialParams> result = new ArrayList<CredentialParams>();
        ConfigParams credentials = config.getSection("credentials");
        if (!credentials.isEmpty()) {
            List<String> sectionsNames = credentials.getSectionNames();
            for (String section : sectionsNames) {
                ConfigParams credential = credentials.getSection(section);
                result.add(new CredentialParams((Map<?, ?>)credential));
            }
        } else {
            ConfigParams credential = config.getSection("credential");
            if (!credential.isEmpty()) {
                result.add(new CredentialParams((Map<?, ?>)credential));
            } else if (configAsDefault) {
                result.add(new CredentialParams((Map<?, ?>)config));
            }
        }
        return result;
    }

    public static List<CredentialParams> manyFromConfig(ConfigParams config) {
        return CredentialParams.manyFromConfig(config, true);
    }

    public static CredentialParams fromConfig(ConfigParams config, boolean configAsDefault) {
        List<CredentialParams> connections = CredentialParams.manyFromConfig(config, configAsDefault);
        return !connections.isEmpty() ? connections.get(0) : null;
    }

    public static CredentialParams fromConfig(ConfigParams config) {
        return CredentialParams.fromConfig(config, true);
    }

    public static CredentialParams fromValue(Object value) {
        Map<String, Object> map = RecursiveObjectReader.getProperties(value);
        return new CredentialParams(map);
    }

    public static CredentialParams fromTuples(Object ... tuples) {
        StringValueMap map = StringValueMap.fromTuplesArray(tuples);
        return new CredentialParams((Map<?, ?>)map);
    }

    public static CredentialParams mergeConfigs(ConfigParams ... configs) {
        StringValueMap map = StringValueMap.fromMaps(configs);
        return new CredentialParams((Map<?, ?>)map);
    }

    public static CredentialParams mergeConfigs(List<ConfigParams> configs) {
        ConfigParams[] unpackConn = new ConfigParams[configs.size()];
        AtomicInteger i = new AtomicInteger();
        configs.forEach((? super T c) -> {
            unpackConn[i.get()] = ConfigParams.fromValue(c);
            i.getAndIncrement();
        });
        return CredentialParams.mergeConfigs(unpackConn);
    }
}

