/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.components.refer;

public class Reference {
    private final Object _locator;
    private final Object _reference;

    public Reference(Object locator, Object reference) throws NullPointerException {
        if (reference == null) {
            throw new NullPointerException("Object reference cannot be null");
        }
        this._locator = locator;
        this._reference = reference;
    }

    public boolean match(Object locator) {
        if (this._reference.equals(locator)) {
            return true;
        }
        if (locator instanceof Class) {
            return ((Class)locator).isInstance(this._reference);
        }
        if (this._locator != null) {
            return this._locator.equals(locator);
        }
        return false;
    }

    public Object getLocator() {
        return this._locator;
    }

    public Object getComponent() {
        return this._reference;
    }
}

