/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.components.refer;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.pipservices4.commons.convert.StringConverter;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IReconfigurable;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;

public class DependencyResolver
implements IReferenceable,
IReconfigurable {
    private final Map<String, Object> _dependencies = new HashMap<String, Object>();
    private IReferences _references;

    public DependencyResolver() {
    }

    public DependencyResolver(ConfigParams config) {
        try {
            this.configure(config);
        }
        catch (ConfigException e) {
            e.printStackTrace();
        }
    }

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        ConfigParams dependencies = config.getSection("dependencies");
        for (String name : dependencies.keySet()) {
            String locator = dependencies.get(name);
            if (locator == null) continue;
            try {
                Descriptor descriptor = Descriptor.fromString(locator);
                this._dependencies.put(name, Objects.requireNonNullElse(descriptor, locator));
            }
            catch (Exception ex) {
                this._dependencies.put(name, locator);
            }
        }
    }

    @Override
    public void setReferences(IReferences references) {
        this._references = references;
    }

    public void put(String name, Object locator) {
        this._dependencies.put(name, locator);
    }

    private Object find(String name) {
        if (name == null) {
            throw new NullPointerException("Dependency name cannot be null");
        }
        if (this._references == null) {
            throw new NullPointerException("References shall be set");
        }
        return this._dependencies.get(name);
    }

    public List<Object> getOptional(String name) {
        Object locator = this.find(name);
        return locator != null ? this._references.getOptional(locator) : null;
    }

    public <T> List<T> getOptional(Class<T> type, String name) {
        Object locator = this.find(name);
        return locator != null ? this._references.getOptional(type, locator) : null;
    }

    public List<Object> getRequired(String name) throws ReferenceException {
        Object locator = this.find(name);
        if (locator == null) {
            throw new ReferenceException(null, name);
        }
        return this._references.getRequired(locator);
    }

    public <T> List<T> getRequired(Class<T> type, String name) throws ReferenceException {
        Object locator = this.find(name);
        if (locator == null) {
            throw new ReferenceException(null, name);
        }
        return this._references.getRequired(type, locator);
    }

    public Object getOneOptional(String name) {
        Object locator = this.find(name);
        return locator != null ? this._references.getOneOptional(locator) : null;
    }

    public <T> T getOneOptional(Class<T> type, String name) {
        Object locator = this.find(name);
        return locator != null ? (T)this._references.getOneOptional(type, locator) : null;
    }

    public Object getOneRequired(String name) throws ReferenceException {
        Object locator = this.find(name);
        if (locator == null) {
            throw new ReferenceException(null, name);
        }
        return this._references.getOneRequired(locator);
    }

    public <T> T getOneRequired(Class<T> type, String name) throws ReferenceException {
        Object locator = this.find(name);
        if (locator == null) {
            throw new ReferenceException(null, name);
        }
        return this._references.getOneRequired(type, locator);
    }

    public List<Object> find(String name, boolean required) throws ReferenceException {
        if (name == null || name.isEmpty()) {
            throw new NullPointerException(name);
        }
        Object locator = this.find(name);
        if (locator == null) {
            if (required) {
                throw new ReferenceException(null, name);
            }
            return null;
        }
        return this._references.find(locator, required);
    }

    public <T> List<T> find(Class<T> type, String name, boolean required) throws ReferenceException {
        if (name == null || name.isEmpty()) {
            throw new NullPointerException(name);
        }
        Object locator = this.find(name);
        if (locator == null) {
            if (required) {
                throw new ReferenceException(null, name);
            }
            return null;
        }
        return this._references.find(locator, required);
    }

    public static DependencyResolver fromTuples(Object ... tuples) {
        DependencyResolver result = new DependencyResolver();
        if (tuples == null || tuples.length == 0) {
            return result;
        }
        for (int index = 0; index < tuples.length && index + 1 < tuples.length; index += 2) {
            String name = StringConverter.toString(tuples[index]);
            Object locator = tuples[index + 1];
            result.put(name, locator);
        }
        return result;
    }

    private Object locate(String name) throws Exception {
        if (name == null) {
            throw new Exception("Dependency name cannot be null");
        }
        if (this._references == null) {
            throw new Exception("References shall be set");
        }
        return this._dependencies.get(name);
    }

    @SafeVarargs
    public static DependencyResolver fromTuples(List<Object> ... tuples) {
        DependencyResolver result = new DependencyResolver();
        if (tuples == null || tuples.length == 0) {
            return result;
        }
        for (int index = 0; index < tuples.length && index + 1 < tuples.length; index += 2) {
            String name = StringConverter.toString(tuples[index]);
            List<Object> locator = tuples[index + 1];
            result.put(name, locator);
        }
        return result;
    }
}

