/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.components.build;

import java.util.ArrayList;
import java.util.List;
import org.pipservices4.commons.reflect.TypeReflector;
import org.pipservices4.components.build.CreateException;
import org.pipservices4.components.build.IFactory;

public class Factory
implements IFactory {
    private final List<Registration> _registrations = new ArrayList<Registration>();

    public void register(Object locator, IComponentFactory factory) {
        if (locator == null) {
            throw new NullPointerException("Locator cannot be null");
        }
        if (factory == null) {
            throw new NullPointerException("Factory cannot be null");
        }
        this._registrations.add(new Registration(locator, factory));
    }

    public void registerAsType(Object locator, Class<?> type) {
        if (locator == null) {
            throw new NullPointerException("Locator cannot be null");
        }
        if (type == null) {
            throw new NullPointerException("Type cannot be null");
        }
        DefaultComponentFactory factory = new DefaultComponentFactory(type);
        this._registrations.add(new Registration(locator, factory));
    }

    @Override
    public Object canCreate(Object locator) {
        for (Registration registration : this._registrations) {
            Object thisLocator = registration.getLocator();
            if (!thisLocator.equals(locator)) continue;
            return thisLocator;
        }
        return null;
    }

    @Override
    public Object create(Object locator) throws CreateException {
        for (Registration registration : this._registrations) {
            if (!registration.getLocator().equals(locator)) continue;
            try {
                return registration.getFactory().create(locator);
            }
            catch (Exception ex) {
                if (ex instanceof CreateException) {
                    throw (CreateException)ex;
                }
                throw (CreateException)new CreateException(null, "Failed to create object for " + locator).withCause(ex);
            }
        }
        return null;
    }

    private static class Registration {
        private final Object _locator;
        private final IComponentFactory _factory;

        public Registration(Object locator, IComponentFactory factory) {
            this._locator = locator;
            this._factory = factory;
        }

        public Object getLocator() {
            return this._locator;
        }

        public IComponentFactory getFactory() {
            return this._factory;
        }
    }

    public static interface IComponentFactory {
        public Object create(Object var1) throws Exception;
    }

    private static class DefaultComponentFactory
    implements IComponentFactory {
        private final Class<?> _type;

        public DefaultComponentFactory(Class<?> type) {
            this._type = type;
        }

        @Override
        public Object create(Object locator) throws Exception {
            return TypeReflector.createInstanceByType(this._type, new Object[0]);
        }
    }
}

