/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.components.build;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.pipservices4.components.build.CreateException;
import org.pipservices4.components.build.IFactory;

public class CompositeFactory
implements IFactory {
    private final List<IFactory> _factories = new ArrayList<IFactory>();

    public CompositeFactory() {
    }

    public CompositeFactory(IFactory ... factories) {
        if (factories != null) {
            Collections.addAll(this._factories, factories);
        }
    }

    public void add(IFactory factory) {
        if (factory == null) {
            throw new NullPointerException("Factory cannot be null");
        }
        this._factories.add(factory);
    }

    public void remove(IFactory factory) {
        this._factories.remove(factory);
    }

    @Override
    public Object canCreate(Object locator) {
        if (locator == null) {
            throw new NullPointerException("Locator cannot be null");
        }
        for (int index = this._factories.size() - 1; index >= 0; --index) {
            Object thisLocator = this._factories.get(index).canCreate(locator);
            if (thisLocator == null) continue;
            return thisLocator;
        }
        return null;
    }

    @Override
    public Object create(Object locator) throws CreateException {
        if (locator == null) {
            throw new NullPointerException("Locator cannot be null");
        }
        for (int index = this._factories.size() - 1; index >= 0; --index) {
            IFactory factory = this._factories.get(index);
            if (factory.canCreate(locator) == null) continue;
            return factory.create(locator);
        }
        throw new CreateException(null, locator);
    }
}

