/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.reflect;

import java.io.File;
import java.lang.reflect.Constructor;
import java.net.URL;
import java.net.URLClassLoader;
import org.pipservices4.commons.convert.TypeCode;
import org.pipservices4.commons.convert.TypeConverter;
import org.pipservices4.commons.errors.NotFoundException;
import org.pipservices4.commons.errors.UnsupportedException;
import org.pipservices4.commons.reflect.TypeDescriptor;

public class TypeReflector {
    public static Class<?> getType(String name, String library) {
        try {
            if (library != null && !library.isEmpty()) {
                URL moduleUrl = new File(library).toURI().toURL();
                URLClassLoader child = new URLClassLoader(new URL[]{moduleUrl}, ClassLoader.getSystemClassLoader());
                return Class.forName(name, true, child);
            }
            return Class.forName(name);
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static Class<?> getType(String name) {
        return TypeReflector.getType(name, null);
    }

    public static Class<?> getTypeByDescriptor(TypeDescriptor type) {
        if (type == null) {
            throw new NullPointerException("Type descriptor cannot be null");
        }
        return TypeReflector.getType(type.getName(), type.getLibrary());
    }

    public static Object createInstanceByType(Class<?> type, Object ... args) throws Exception {
        if (args.length == 0) {
            Constructor<?> constructor = type.getConstructor(new Class[0]);
            return constructor.newInstance(new Object[0]);
        }
        throw new UnsupportedException(null, "NOT_SUPPORTED", "Constructors with parameters are not supported");
    }

    public static Object createInstance(String name, String library, Object ... args) throws Exception {
        Class<?> type = TypeReflector.getType(name, library);
        if (type == null) {
            throw new NotFoundException(null, "TYPE_NOT_FOUND", "Type " + name + "," + library + " was not found").withDetails("type", name).withDetails("library", library);
        }
        return TypeReflector.createInstanceByType(type, args);
    }

    public static Object createInstance(String name, Object ... args) throws Exception {
        return TypeReflector.createInstance(name, null, args);
    }

    public static Object createInstanceByDescriptor(TypeDescriptor type, Object ... args) throws Exception {
        if (type == null) {
            throw new NullPointerException("Type descriptor cannot be null");
        }
        return TypeReflector.createInstance(type.getName(), type.getLibrary(), args);
    }

    public static boolean isPrimitive(Object value) {
        TypeCode typeCode = TypeConverter.toTypeCode(value);
        return typeCode == TypeCode.String || typeCode == TypeCode.Enum || typeCode == TypeCode.Boolean || typeCode == TypeCode.Integer || typeCode == TypeCode.Long || typeCode == TypeCode.Float || typeCode == TypeCode.Double || typeCode == TypeCode.DateTime || typeCode == TypeCode.Duration;
    }
}

