/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.reflect;

import org.pipservices4.commons.convert.DateTimeConverter;
import org.pipservices4.commons.convert.TypeCode;
import org.pipservices4.commons.convert.TypeConverter;

public class TypeMatcher {
    public static boolean matchValueType(Object expectedType, Object actualValue) {
        if (expectedType == null) {
            return true;
        }
        if (actualValue == null) {
            throw new NullPointerException("Actual value cannot be null");
        }
        return TypeMatcher.matchType(expectedType, TypeConverter.toTypeCode(actualValue.getClass()));
    }

    public static boolean matchType(Object expectedType, TypeCode actualType, Object actualValue) {
        TypeCode type;
        if (expectedType == null) {
            return true;
        }
        if (actualType == null) {
            throw new NullPointerException("Actual type cannot be null");
        }
        if (!(expectedType instanceof String) && (type = expectedType instanceof Class ? TypeConverter.toTypeCode(expectedType) : (TypeCode)((Object)expectedType)) != null) {
            if (type == actualType) {
                return true;
            }
            if (type == TypeCode.Integer && (actualType == TypeCode.Long || actualType == TypeCode.Float || actualType == TypeCode.Double)) {
                return true;
            }
            if (type == TypeCode.Long && (actualType == TypeCode.Integer || actualType == TypeCode.Float || actualType == TypeCode.Double)) {
                return true;
            }
            if (type == TypeCode.Float && (actualType == TypeCode.Integer || actualType == TypeCode.Long || actualType == TypeCode.Double)) {
                return true;
            }
            if (type == TypeCode.Double && (actualType == TypeCode.Integer || actualType == TypeCode.Long || actualType == TypeCode.Float)) {
                return true;
            }
            return type == TypeCode.DateTime && actualType == TypeCode.String && DateTimeConverter.toNullableDateTime(actualValue) != null;
        }
        if (expectedType.equals((Object)actualType)) {
            return true;
        }
        if (expectedType instanceof String) {
            return TypeMatcher.matchTypeByName((String)expectedType, actualType, actualValue);
        }
        return TypeMatcher.matchTypeByName(expectedType.toString(), actualType);
    }

    public static boolean matchType(Object expectedType, TypeCode actualType) {
        return TypeMatcher.matchType(expectedType, actualType, null);
    }

    public static boolean matchValueTypeByName(String expectedType, Object actualValue) {
        if (expectedType == null) {
            return true;
        }
        if (actualValue == null) {
            throw new NullPointerException("Actual value cannot be null");
        }
        return TypeMatcher.matchTypeByName(expectedType, TypeConverter.toTypeCode(actualValue.getClass()));
    }

    public static boolean matchTypeByName(String expectedType, TypeCode actualType, Object actualValue) {
        if (expectedType == null) {
            return true;
        }
        if (actualType == null) {
            throw new NullPointerException("Actual type cannot be null");
        }
        if ((expectedType = expectedType.toLowerCase()).equals("object")) {
            return true;
        }
        if (expectedType.equals("int") || expectedType.equals("integer")) {
            return actualType == TypeCode.Integer || actualType == TypeCode.Long;
        }
        if (expectedType.equals("long")) {
            return actualType == TypeCode.Long || actualType == TypeCode.Integer;
        }
        if (expectedType.equals("float")) {
            return actualType == TypeCode.Float || actualType == TypeCode.Double || actualType == TypeCode.Integer || actualType == TypeCode.Long;
        }
        if (expectedType.equals("double")) {
            return actualType == TypeCode.Double || actualType == TypeCode.Float;
        }
        if (expectedType.equals("string")) {
            return actualType == TypeCode.String;
        }
        if (expectedType.equals("bool") || expectedType.equals("boolean")) {
            return actualType == TypeCode.Boolean;
        }
        if (expectedType.equals("date") || expectedType.equals("datetime")) {
            return actualType == TypeCode.DateTime || actualType == TypeCode.String && DateTimeConverter.toNullableDateTime(actualValue) != null;
        }
        if (expectedType.equals("timespan") || expectedType.equals("duration")) {
            return actualType == TypeCode.Integer || actualType == TypeCode.Long || actualType == TypeCode.Float || actualType == TypeCode.Double;
        }
        if (expectedType.equals("enum")) {
            return actualType == TypeCode.Integer || actualType == TypeCode.String;
        }
        if (expectedType.equals("map") || expectedType.equals("dict") || expectedType.equals("dictionary")) {
            return actualType == TypeCode.Map;
        }
        if (expectedType.equals("array") || expectedType.equals("list")) {
            return actualType == TypeCode.Array;
        }
        if (expectedType.endsWith("[]")) {
            return actualType == TypeCode.Array;
        }
        return false;
    }

    public static boolean matchTypeByName(String expectedType, TypeCode actualType) {
        return TypeMatcher.matchTypeByName(expectedType, actualType, null);
    }
}

