/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.commons.convert;

import java.time.Duration;
import java.util.Calendar;
import java.util.Date;

public class DoubleConverter {
    public static Double toNullableDouble(Object value) {
        if (value == null) {
            return null;
        }
        if (value instanceof Date) {
            return ((Date)value).getTime();
        }
        if (value instanceof Calendar) {
            return ((Calendar)value).getTimeInMillis();
        }
        if (value instanceof Duration) {
            return ((Duration)value).toMillis();
        }
        if (value instanceof Boolean) {
            return (Boolean)value != false ? 1.0 : 0.0;
        }
        if (value instanceof Integer) {
            return (double)((Integer)value);
        }
        if (value instanceof Short) {
            return (double)((Short)value);
        }
        if (value instanceof Long) {
            return (double)((Long)value);
        }
        if (value instanceof Float) {
            return ((Float)value).floatValue();
        }
        if (value instanceof Double) {
            return (double)((Double)value);
        }
        if (value instanceof String) {
            try {
                return Double.parseDouble((String)value);
            }
            catch (NumberFormatException ex) {
                return null;
            }
        }
        return null;
    }

    public static double toDouble(Object value) {
        return DoubleConverter.toDoubleWithDefault(value, 0.0);
    }

    public static double toDoubleWithDefault(Object value, double defaultValue) {
        Double result = DoubleConverter.toNullableDouble(value);
        return result != null ? result : defaultValue;
    }
}

