/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.rpc.clients;

import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.commons.errors.ConnectionException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.DependencyResolver;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.components.run.IOpenable;
import org.pipservices4.observability.count.CompositeCounters;
import org.pipservices4.observability.count.CounterTiming;
import org.pipservices4.observability.log.CompositeLogger;
import org.pipservices4.observability.trace.CompositeTracer;
import org.pipservices4.observability.trace.TraceTiming;
import org.pipservices4.rpc.trace.InstrumentTiming;

public abstract class DirectClient<T>
implements IConfigurable,
IOpenable,
IReferenceable {
    protected T _service;
    protected CompositeLogger _logger = new CompositeLogger();
    protected CompositeCounters _counters = new CompositeCounters();
    protected DependencyResolver _dependencyResolver = new DependencyResolver();
    protected boolean _opened = false;
    protected CompositeTracer _tracer = new CompositeTracer();

    public DirectClient() {
        this._dependencyResolver.put("service", "none");
    }

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        this._dependencyResolver.configure(config);
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException {
        this._logger.setReferences(references);
        this._counters.setReferences(references);
        this._tracer.setReferences(references);
        this._dependencyResolver.setReferences(references);
        this._service = this._dependencyResolver.getOneRequired("service");
    }

    protected InstrumentTiming instrument(IContext context, String name) {
        this._logger.trace(context, "Calling %s method", name);
        this._counters.incrementOne(name + ".call_count");
        CounterTiming counterTiming = this._counters.beginTiming(name + ".call_time");
        TraceTiming traceTiming = this._tracer.beginTrace(context, name, null);
        return new InstrumentTiming(context, name, "call", this._logger, this._counters, counterTiming, traceTiming);
    }

    @Override
    public boolean isOpen() {
        return this._opened;
    }

    @Override
    public void open(IContext context) throws ConnectionException {
        if (this.isOpen()) {
            return;
        }
        if (this._service == null) {
            throw new ConnectionException(context != null ? ContextResolver.getTraceId(context) : null, "NO_SERVICE", "Service reference is missing");
        }
        this._logger.info(context, "Opened Direct client {0}", this.getClass().getName());
        this._opened = true;
    }

    @Override
    public void close(IContext context) {
        if (this.isOpen()) {
            this._logger.debug(context, "Closed Direct client {0}", this.getClass().getName());
        }
        this._opened = false;
    }
}

