/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.observability.trace;

import java.util.ArrayList;
import java.util.List;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.observability.trace.ITracer;
import org.pipservices4.observability.trace.TraceTiming;

public class CompositeTracer
implements ITracer,
IReferenceable {
    protected final List<ITracer> _tracers = new ArrayList<ITracer>();

    public CompositeTracer(IReferences references) throws ReferenceException, ConfigException {
        if (references != null) {
            this.setReferences(references);
        }
    }

    public CompositeTracer() {
    }

    @Override
    public void setReferences(IReferences references) {
        List<ITracer> tracers = references.getOptional(ITracer.class, new Descriptor(null, "tracer", null, null, null));
        for (ITracer tracer : tracers) {
            if (tracer == this) continue;
            this._tracers.add(tracer);
        }
    }

    @Override
    public void trace(IContext context, String component, String operation, Long duration) {
        for (ITracer tracer : this._tracers) {
            tracer.trace(context, component, operation, duration);
        }
    }

    @Override
    public void failure(IContext context, String component, String operation, Exception error, long duration) {
        for (ITracer tracer : this._tracers) {
            tracer.failure(context, component, operation, error, duration);
        }
    }

    @Override
    public TraceTiming beginTrace(IContext context, String component, String operation) {
        return new TraceTiming(context, component, operation, this);
    }
}

