/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.observability.log;

import java.util.Arrays;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IReconfigurable;
import org.pipservices4.components.context.ContextInfo;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.Descriptor;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.observability.log.ILogger;
import org.pipservices4.observability.log.LogLevel;
import org.pipservices4.observability.log.LogLevelConverter;

public abstract class Logger
implements ILogger,
IReconfigurable,
IReferenceable {
    private LogLevel _level = LogLevel.Info;
    protected String _source = null;

    protected Logger() {
    }

    @Override
    public void configure(ConfigParams config) {
        this._level = LogLevelConverter.toLogLevel(config.getAsObject("level"), this._level);
        this._source = config.getAsStringWithDefault("source", this._source);
    }

    @Override
    public void setReferences(IReferences references) {
        Object contextInfo = references.getOneOptional(new Descriptor("pip-services", "context-info", "*", "*", "1.0"));
        if (contextInfo instanceof ContextInfo && this._source == null) {
            this._source = ((ContextInfo)contextInfo).getName();
        }
    }

    protected String composeError(Exception error) {
        StringBuilder builder = new StringBuilder();
        for (Throwable t = error; t != null; t = t.getCause()) {
            if (!builder.isEmpty()) {
                builder.append(" Caused by error: ");
            }
            builder.append(t.getMessage()).append(" StackTrace: ").append(Arrays.toString(t.getStackTrace()));
        }
        return builder.toString();
    }

    public String getSource() {
        return this._source;
    }

    public void setSource(String value) {
        this._source = value;
    }

    @Override
    public LogLevel getLevel() {
        return this._level;
    }

    @Override
    public void setLevel(LogLevel value) {
        this._level = value;
    }

    protected abstract void write(LogLevel var1, IContext var2, Exception var3, String var4);

    protected void formatAndWrite(LogLevel level, IContext context, Exception error, String message, Object[] args) {
        String string = message = message != null ? message : "";
        if (args != null && args.length > 0) {
            message = String.format(message, args);
        }
        this.write(level, context, error, message);
    }

    @Override
    public void log(LogLevel level, IContext context, Exception error, String message, Object ... args) {
        this.formatAndWrite(level, context, error, message, args);
    }

    @Override
    public void fatal(IContext context, String message, Object ... args) {
        this.formatAndWrite(LogLevel.Fatal, context, null, message, args);
    }

    @Override
    public void fatal(IContext context, Exception error) {
        this.formatAndWrite(LogLevel.Fatal, context, error, null, null);
    }

    @Override
    public void fatal(IContext context, Exception error, String message, Object ... args) {
        this.formatAndWrite(LogLevel.Fatal, context, error, message, args);
    }

    @Override
    public void error(IContext context, String message, Object ... args) {
        this.formatAndWrite(LogLevel.Error, context, null, message, args);
    }

    @Override
    public void error(IContext context, Exception error) {
        this.formatAndWrite(LogLevel.Error, context, error, null, null);
    }

    @Override
    public void error(IContext context, Exception error, String message, Object ... args) {
        this.formatAndWrite(LogLevel.Error, context, error, message, args);
    }

    @Override
    public void warn(IContext context, String message, Object ... args) {
        this.formatAndWrite(LogLevel.Warn, context, null, message, args);
    }

    @Override
    public void info(IContext context, String message, Object ... args) {
        this.formatAndWrite(LogLevel.Info, context, null, message, args);
    }

    @Override
    public void debug(IContext context, String message, Object ... args) {
        this.formatAndWrite(LogLevel.Debug, context, null, message, args);
    }

    @Override
    public void trace(IContext context, String message, Object ... args) {
        this.formatAndWrite(LogLevel.Trace, context, null, message, args);
    }
}

