/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.observability.count;

import java.util.Comparator;
import java.util.List;
import org.pipservices4.commons.convert.StringConverter;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.observability.count.CachedCounters;
import org.pipservices4.observability.count.Counter;
import org.pipservices4.observability.log.CompositeLogger;

public class LogCounters
extends CachedCounters
implements IReferenceable {
    private final CompositeLogger _logger = new CompositeLogger();

    @Override
    public void setReferences(IReferences references) throws ReferenceException {
        this._logger.setReferences(references);
    }

    private String counterToString(Counter counter) {
        String result = "Counter " + counter.getName() + " { ";
        result = result + "\"type\": " + counter.getType();
        if (counter.getLast() != null) {
            result = result + ", \"last\": " + StringConverter.toString(counter.getLast());
        }
        if (counter.getCount() != null) {
            result = result + ", \"count\": " + StringConverter.toString(counter.getCount());
        }
        if (counter.getMin() != null) {
            result = result + ", \"min\": " + StringConverter.toString(counter.getMin());
        }
        if (counter.getMax() != null) {
            result = result + ", \"max\": " + StringConverter.toString(counter.getMax());
        }
        if (counter.getAverage() != null) {
            result = result + ", \"avg\": " + StringConverter.toString(counter.getAverage());
        }
        if (counter.getTime() != null) {
            result = result + ", \"time\": " + StringConverter.toString(counter.getTime());
        }
        result = result + " }";
        return result;
    }

    @Override
    protected void save(List<Counter> counters) {
        if (counters.isEmpty()) {
            return;
        }
        counters.sort(Comparator.comparing(Counter::getName));
        for (Counter counter : counters) {
            this._logger.info(null, this.counterToString(counter), new Object[0]);
        }
    }
}

