/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.logic.cache;

import java.util.HashMap;
import java.util.Map;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IReconfigurable;
import org.pipservices4.components.context.IContext;
import org.pipservices4.logic.cache.CacheEntry;
import org.pipservices4.logic.cache.ICache;

public class MemoryCache
implements ICache,
IReconfigurable {
    private static final long _defaultTimeout = 60000L;
    private static final long _defaultMaxSize = 1000L;
    private final Object _lock = new Object();
    private final Map<String, CacheEntry> _cache = new HashMap<String, CacheEntry>();
    private int _count = 0;
    private long _timeout = 60000L;
    private long _maxSize = 1000L;

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        this._timeout = config.getAsLongWithDefault("options.timeout", this._timeout);
        this._maxSize = config.getAsLongWithDefault("options.max_size", this._maxSize);
    }

    private void cleanup() {
        CacheEntry oldest = null;
        this._count = 0;
        for (Map.Entry<String, CacheEntry> e : this._cache.entrySet()) {
            String key = e.getKey();
            CacheEntry entry = e.getValue();
            if (entry.isExpired()) {
                this._cache.remove(key);
                continue;
            }
            ++this._count;
            if (oldest != null && oldest.getExpiration() <= entry.getExpiration()) continue;
            oldest = entry;
        }
        if ((long)this._count > this._maxSize && oldest != null) {
            this._cache.remove(oldest.getKey());
            --this._count;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object retrieve(IContext context, String key) {
        Object object = this._lock;
        synchronized (object) {
            if (key == null) {
                throw new NullPointerException("Key cannot be null");
            }
            CacheEntry entry = this._cache.get(key);
            if (entry == null) {
                return null;
            }
            if (entry.isExpired()) {
                this._cache.remove(key);
                --this._count;
                return null;
            }
            return entry.getValue();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Object store(IContext context, String key, Object value, long timeout) {
        Object object = this._lock;
        synchronized (object) {
            if (key == null) {
                throw new NullPointerException("Key cannot be null");
            }
            CacheEntry entry = this._cache.get(key);
            long l = timeout = timeout > 0L ? timeout : this._timeout;
            if (value == null) {
                if (entry != null) {
                    this._cache.remove(key);
                    --this._count;
                }
                return null;
            }
            if (entry != null) {
                entry.setValue(value, timeout);
            } else {
                entry = new CacheEntry(key, value, timeout);
                this._cache.put(key, entry);
                ++this._count;
            }
            if (this._maxSize > 0L && (long)this._count > this._maxSize) {
                this.cleanup();
            }
            return value;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void remove(IContext context, String key) {
        Object object = this._lock;
        synchronized (object) {
            if (key == null) {
                throw new NullPointerException("Key cannot be null");
            }
            CacheEntry entry = this._cache.get(key);
            if (entry != null) {
                this._cache.remove(key);
                --this._count;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void clear(IContext context) {
        Object object = this._lock;
        synchronized (object) {
            this._cache.clear();
            this._count = 0;
        }
    }
}

