/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.http.controllers;

import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.core.Response;
import java.time.ZonedDateTime;
import org.glassfish.jersey.process.Inflector;
import org.pipservices4.commons.convert.StringConverter;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.http.controllers.RestController;

public class HeartbeatRestController
extends RestController {
    private String _route = "heartbeat";

    @Override
    public void configure(ConfigParams config) throws ConfigException {
        super.configure(config);
        this._route = config.getAsStringWithDefault("route", this._route);
    }

    @Override
    public void register() {
        this.registerRoute("GET", this._route, new Inflector<ContainerRequestContext, Response>(){

            @Override
            public Response apply(ContainerRequestContext request) {
                return HeartbeatRestController.this.heartbeat(request);
            }
        });
    }

    private Response heartbeat(ContainerRequestContext request) {
        String result = StringConverter.toString(ZonedDateTime.now());
        return this.sendResult(result);
    }
}

