/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.http.clients;

import jakarta.ws.rs.client.Client;
import jakarta.ws.rs.client.ClientBuilder;
import jakarta.ws.rs.client.Entity;
import jakarta.ws.rs.core.GenericType;
import jakarta.ws.rs.core.MultivaluedHashMap;
import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import jakarta.ws.rs.core.UriBuilder;
import java.net.URI;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.time.temporal.ChronoUnit;
import net.jodah.failsafe.Failsafe;
import net.jodah.failsafe.Policy;
import net.jodah.failsafe.RetryPolicy;
import org.glassfish.jersey.client.ClientConfig;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.ApplicationExceptionFactory;
import org.pipservices4.commons.errors.ErrorDescription;
import org.pipservices4.commons.errors.InvalidStateException;
import org.pipservices4.commons.errors.UnknownException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.components.refer.ReferenceException;
import org.pipservices4.components.run.IOpenable;
import org.pipservices4.config.connect.ConnectionParams;
import org.pipservices4.config.connect.HttpConnectionResolver;
import org.pipservices4.data.query.FilterParams;
import org.pipservices4.data.query.PagingParams;
import org.pipservices4.observability.count.CompositeCounters;
import org.pipservices4.observability.count.CounterTiming;
import org.pipservices4.observability.log.CompositeLogger;
import org.pipservices4.observability.trace.CompositeTracer;
import org.pipservices4.observability.trace.TraceTiming;
import org.pipservices4.rpc.trace.InstrumentTiming;

public class RestClient
implements IOpenable,
IConfigurable,
IReferenceable {
    private static final ConfigParams _defaultConfig = ConfigParams.fromTuples("connection.protocol", "http", "connection.host", "0.0.0.0", "connection.port", 3000, "options.request_max_size", 0x100000, "options.connect_timeout", 10000, "options.timeout", 10000, "options.retries", 3, "options.debug", true);
    protected HttpConnectionResolver _connectionResolver = new HttpConnectionResolver();
    protected CompositeLogger _logger = new CompositeLogger();
    protected CompositeCounters _counters = new CompositeCounters();
    protected CompositeTracer _tracer = new CompositeTracer();
    protected ConfigParams _options = new ConfigParams();
    protected String _baseRoute;
    protected int _retries = 1;
    protected long _connectTimeout = 10000L;
    protected long _timeout = 10000L;
    protected MultivaluedMap<String, Object> _headers = new MultivaluedHashMap<String, Object>();
    protected String _contextLocation = "query";
    protected String _url;
    protected Client _client;
    private RetryPolicy<Object> _retryPolicy;

    protected RestClient() {
        this(null);
    }

    protected RestClient(String baseRoute) {
        this._baseRoute = baseRoute;
    }

    @Override
    public void configure(ConfigParams config) {
        config = config.setDefaults(_defaultConfig);
        this._connectionResolver.configure(config);
        this._options = this._options.override(config.getSection("options"));
        this._retries = config.getAsIntegerWithDefault("options.retries", this._retries);
        this._connectTimeout = config.getAsLongWithDefault("options.connect_timeout", this._connectTimeout);
        this._timeout = config.getAsLongWithDefault("options.timeout", this._timeout);
        this._baseRoute = config.getAsStringWithDefault("base_route", this._baseRoute);
        this._contextLocation = config.getAsStringWithDefault("options.trace_id_place", this._contextLocation);
        this._contextLocation = config.getAsStringWithDefault("options.trace_id", this._contextLocation);
    }

    @Override
    public void setReferences(IReferences references) throws ReferenceException {
        this._logger.setReferences(references);
        this._counters.setReferences(references);
        this._tracer.setReferences(references);
        this._connectionResolver.setReferences(references);
    }

    protected InstrumentTiming instrument(IContext context, String name) {
        this._logger.trace(context, "Calling %s method", name);
        this._counters.incrementOne(name + ".call_count");
        CounterTiming counterTiming = this._counters.beginTiming(name + ".call_time");
        TraceTiming traceTiming = this._tracer.beginTrace(context, name, null);
        return new InstrumentTiming(context, name, "call", this._logger, this._counters, counterTiming, traceTiming);
    }

    @Override
    public boolean isOpen() {
        return this._client != null;
    }

    @Override
    public void open(IContext context) throws ApplicationException {
        if (this._client != null) {
            return;
        }
        ConnectionParams connection = this._connectionResolver.resolve(context);
        String protocol = connection.getProtocolWithDefault("http");
        String host = connection.getHost();
        int port = connection.getPort();
        this._url = protocol + "://" + host + ":" + port;
        ClientConfig clientConfig = new ClientConfig();
        clientConfig.property("jersey.config.client.connectTimeout", this._connectTimeout);
        clientConfig.property("jersey.config.client.readTimeout", this._timeout);
        this._retryPolicy = new RetryPolicy().withDelay(this._timeout, this._timeout * 10L, ChronoUnit.MILLIS).withMaxRetries(this._retries);
        clientConfig.register(new JacksonFeature());
        this._client = ClientBuilder.newClient(clientConfig);
        this._logger.debug(context, "Connected via REST to %s", this._url);
    }

    @Override
    public void close(IContext context) {
        if (this._client == null) {
            return;
        }
        this._client.close();
        this._client = null;
        this._logger.debug(context, "Disconnected from %s", this._url);
        this._url = null;
    }

    private URI createRequestUri(String route) {
        StringBuilder builder = new StringBuilder(this._url);
        if (this._baseRoute != null && !this._baseRoute.trim().isEmpty()) {
            if (this._baseRoute.charAt(0) != '/') {
                builder.append('/');
            }
            builder.append(this._baseRoute);
        }
        if (route.charAt(0) != '/') {
            builder.append('/');
        }
        builder.append(route);
        String uri = builder.toString();
        return UriBuilder.fromUri(uri).build(new Object[0]);
    }

    private String addQueryParameter(String query, String name, String value) {
        name = URLEncoder.encode(name, StandardCharsets.UTF_8);
        value = value != null ? URLEncoder.encode(value, StandardCharsets.UTF_8) : "";
        int pos = query.indexOf(63);
        String path = pos >= 0 ? query.substring(0, pos) : query;
        String parameters = pos >= 0 ? query.substring(pos) : "";
        return path + "?" + (parameters.isEmpty() ? "" : "&") + name + "=" + value;
    }

    protected String addTraceId(String route, IContext context) {
        if (context == null) {
            return route;
        }
        return this.addQueryParameter(route, "trace_id", ContextResolver.getTraceId(context));
    }

    protected String addFilterParams(String route, FilterParams filter) {
        for (String key : filter.keySet()) {
            route = this.addQueryParameter(route, key, filter.get(key));
        }
        return route;
    }

    protected String addPagingParams(String route, PagingParams paging) {
        if (paging.getSkip() != null) {
            route = this.addQueryParameter(route, "skip", paging.getSkip().toString());
        }
        if (paging.getTake() != null) {
            route = this.addQueryParameter(route, "take", paging.getTake().toString());
        }
        if (paging.hasTotal()) {
            route = this.addQueryParameter(route, "total", paging.getTake().toString());
        }
        return route;
    }

    protected Response executeRequest(IContext context, String method, URI uri, String mediaType, Entity<?> body) throws ApplicationException {
        if (this._client == null) {
            throw new InvalidStateException(context != null ? ContextResolver.getTraceId(context) : null, "NOT_OPENED", "Client is not opened");
        }
        Response response = Failsafe.with(this._retryPolicy, (Policy[])new RetryPolicy[0]).get(() -> this._client.target(uri).request(mediaType).headers(this._headers).method(method, body));
        if (response == null) {
            throw new UnknownException(context != null ? ContextResolver.getTraceId(context) : null, "NO_RESPONSE", "Unable to get a result from " + method + " " + uri);
        }
        if (response.getStatus() >= 400) {
            ErrorDescription errorObject;
            try {
                errorObject = response.readEntity(ErrorDescription.class);
            }
            catch (Exception ex) {
                Object res = response.readEntity(Object.class);
                String responseContent = res.toString();
                throw new UnknownException(context != null ? ContextResolver.getTraceId(context) : null, "UNKNOWN_ERROR", responseContent);
            }
            if (errorObject != null) {
                throw ApplicationExceptionFactory.create(errorObject);
            }
        }
        return response;
    }

    private Response executeJsonRequest(IContext context, String method, String route, Object requestEntity) throws ApplicationException {
        route = this.addTraceId(route, context);
        URI uri = this.createRequestUri(route);
        Entity<Object> body = Entity.entity(requestEntity, "application/json");
        return this.executeRequest(context, method, uri, "application/json", body);
    }

    protected <T> T call(Class<T> type, IContext context, String method, String route, Object requestEntity) throws ApplicationException {
        try (Response response = this.executeJsonRequest(context, method, route, requestEntity);){
            T t = response.readEntity(type);
            return t;
        }
    }

    protected <T> T call(GenericType<T> type, IContext context, String method, String route, Object requestEntity) throws ApplicationException {
        try (Response response = this.executeJsonRequest(context, method, route, requestEntity);){
            T t = response.readEntity(type);
            return t;
        }
    }
}

