/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.expressions.tokenizers.utilities;

import java.util.ArrayList;
import java.util.List;
import org.pipservices4.expressions.tokenizers.utilities.CharReferenceInterval;

public class CharReferenceMap<T> {
    private List<T> _initialInterval;
    private List<CharReferenceInterval<T>> _otherIntervals;

    public CharReferenceMap() {
        this.clear();
    }

    public void addDefaultInterval(T reference) throws Exception {
        this.addInterval(0, 65534, reference);
    }

    public void addInterval(int start, int end, T reference) throws Exception {
        if (start > end) {
            throw new Exception("Start must be less or equal End");
        }
        end = end == 65535 ? 65534 : end;
        for (int index = start; index < 256 && index <= end; ++index) {
            this._initialInterval.set(index, reference);
        }
        if (end >= 256) {
            start = Math.max(start, 256);
            this._otherIntervals.set(0, new CharReferenceInterval<T>(start, end, reference));
        }
    }

    public void clear() {
        this._initialInterval = new ArrayList<T>(255);
        this._otherIntervals = new ArrayList<CharReferenceInterval<T>>(255);
        for (int index = 0; index < 256; ++index) {
            this._initialInterval.add(null);
            this._otherIntervals.add(null);
        }
    }

    public T lookup(int symbol) {
        if (symbol < 256) {
            return this._initialInterval.get(symbol);
        }
        for (CharReferenceInterval<T> interval : this._otherIntervals) {
            if (interval == null || !interval.inRange(symbol)) continue;
            return interval.getReference();
        }
        return null;
    }
}

