/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.expressions.tokenizers.generic;

import org.pipservices4.expressions.io.IScanner;
import org.pipservices4.expressions.tokenizers.INumberState;
import org.pipservices4.expressions.tokenizers.ITokenizer;
import org.pipservices4.expressions.tokenizers.Token;
import org.pipservices4.expressions.tokenizers.TokenType;
import org.pipservices4.expressions.tokenizers.utilities.CharValidator;

public class GenericNumberState
implements INumberState {
    protected final int MINUS = 45;
    protected final int DOT = 46;

    @Override
    public Token nextToken(IScanner scanner, ITokenizer tokenizer) throws Exception {
        boolean absorbedDot = false;
        boolean gotADigit = false;
        StringBuilder tokenValue = new StringBuilder();
        int nextSymbol = scanner.read();
        int line = scanner.line();
        int column = scanner.column();
        if (nextSymbol == this.MINUS) {
            tokenValue.append('-');
            nextSymbol = scanner.read();
        }
        while (CharValidator.isDigit(nextSymbol) && !CharValidator.isEof(nextSymbol)) {
            gotADigit = true;
            tokenValue.append((char)nextSymbol);
            nextSymbol = scanner.read();
        }
        if (nextSymbol == this.DOT) {
            absorbedDot = true;
            tokenValue.append('.');
            nextSymbol = scanner.read();
            while (CharValidator.isDigit(nextSymbol) && !CharValidator.isEof(nextSymbol)) {
                gotADigit = true;
                tokenValue.append((char)nextSymbol);
                nextSymbol = scanner.read();
            }
        }
        if (!CharValidator.isEof(nextSymbol)) {
            scanner.unread();
        }
        if (!gotADigit) {
            scanner.unreadMany(tokenValue.length());
            if (tokenizer.getSymbolState() != null) {
                return tokenizer.getSymbolState().nextToken(scanner, tokenizer);
            }
            throw new Exception("Tokenizer must have an assigned symbol state.");
        }
        return new Token(absorbedDot ? TokenType.Float : TokenType.Integer, tokenValue.toString(), line, column);
    }
}

