/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.validate;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.reflect.ObjectReader;
import org.pipservices4.data.validate.IValidationRule;
import org.pipservices4.data.validate.PropertySchema;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.data.validate.ValidationResult;
import org.pipservices4.data.validate.ValidationResultType;

public class ObjectSchema
extends Schema {
    private List<PropertySchema> _properties;
    private boolean _allowUndefined = false;

    public List<PropertySchema> getProperties() {
        return this._properties;
    }

    public void setProperties(List<PropertySchema> value) {
        this._properties = value;
    }

    public boolean isUndefinedAllowed() {
        return this._allowUndefined;
    }

    public void setUndefinedAllowed(boolean value) {
        this._allowUndefined = value;
    }

    public ObjectSchema allowUndefined(boolean value) {
        this._allowUndefined = value;
        return this;
    }

    public ObjectSchema withProperty(PropertySchema schema) {
        this._properties = this._properties != null ? this._properties : new ArrayList<PropertySchema>();
        this._properties.add(schema);
        return this;
    }

    public ObjectSchema withRequiredProperty(String name, Object type, IValidationRule ... rules) {
        this._properties = this._properties != null ? this._properties : new ArrayList<PropertySchema>();
        PropertySchema schema = new PropertySchema(name, type);
        schema.setRules(Arrays.asList(rules));
        schema.makeRequired();
        return this.withProperty(schema);
    }

    public ObjectSchema withOptionalProperty(String name, Object type, IValidationRule ... rules) {
        this._properties = this._properties != null ? this._properties : new ArrayList<PropertySchema>();
        PropertySchema schema = new PropertySchema(name, type);
        schema.setRules(Arrays.asList(rules));
        schema.makeOptional();
        return this.withProperty(schema);
    }

    @Override
    protected void performValidation(String path, Object value, List<ValidationResult> results) {
        super.performValidation(path, value, results);
        if (value == null) {
            return;
        }
        String name = path != null ? path : "value";
        Map<String, Object> properties = ObjectReader.getProperties(value);
        if (this._properties != null) {
            for (PropertySchema propertySchema : this._properties) {
                String processedName = null;
                for (Map.Entry<String, Object> entry : properties.entrySet()) {
                    String propertyName = entry.getKey();
                    Object propertyValue = entry.getValue();
                    if (!propertyName.equalsIgnoreCase(propertySchema.getName())) continue;
                    propertySchema.performValidation(path, propertyValue, results);
                    processedName = propertyName;
                    break;
                }
                if (processedName == null) {
                    propertySchema.performValidation(path, null, results);
                    continue;
                }
                properties.remove(processedName);
            }
        }
        for (Map.Entry entry : properties.entrySet()) {
            String propertyPath = path == null || path.isEmpty() ? (String)entry.getKey() : path + "." + (String)entry.getKey();
            results.add(new ValidationResult(propertyPath, ValidationResultType.Warning, "UNEXPECTED_PROPERTY", name + " contains unexpected property " + (String)entry.getKey(), null, entry.getKey()));
        }
    }
}

