/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.validate;

import java.util.List;
import java.util.Map;
import org.pipservices4.commons.reflect.ObjectReader;
import org.pipservices4.data.validate.IValidationRule;
import org.pipservices4.data.validate.Schema;
import org.pipservices4.data.validate.ValidationResult;
import org.pipservices4.data.validate.ValidationResultType;

public class MapSchema
extends Schema {
    private Object _keyType;
    private Object _valueType;

    public MapSchema() {
    }

    public MapSchema(Object keyType, Object valueType) {
        this._keyType = keyType;
        this._valueType = valueType;
    }

    public MapSchema(Object keyType, Object valueType, Boolean required, List<IValidationRule> rules) {
        super(required, rules);
        this._keyType = keyType;
        this._valueType = valueType;
    }

    public Object getKeyType() {
        return this._keyType;
    }

    public void setKeyType(Object value) {
        this._keyType = value;
    }

    public Object getValueType() {
        return this._valueType;
    }

    public void setValueType(Object value) {
        this._valueType = value;
    }

    @Override
    protected void performValidation(String path, Object value, List<ValidationResult> results) {
        String name = path != null ? path : "value";
        value = ObjectReader.getValue(value);
        super.performValidation(path, value, results);
        if (value == null) {
            return;
        }
        if (value instanceof Map) {
            Map map = (Map)value;
            for (Object key : map.keySet()) {
                String elementPath = path == null || path.isEmpty() ? key.toString() : path + "." + String.valueOf(key);
                this.performTypeValidation(elementPath, this._keyType, key, results);
                this.performTypeValidation(elementPath, this._valueType, map.get(key), results);
            }
        } else {
            results.add(new ValidationResult(path, ValidationResultType.Error, "VALUE_ISNOT_MAP", name + " type must be Map", "Map", value.getClass()));
        }
    }
}

