/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.data.random;

import java.time.ZoneId;
import java.time.ZonedDateTime;
import org.pipservices4.data.random.RandomFloat;
import org.pipservices4.data.random.RandomInteger;

public class RandomDateTime {
    public static ZonedDateTime nextDate(int minYear, int maxYear) {
        int currentYear = ZonedDateTime.now().getYear();
        minYear = minYear == 0 ? currentYear - RandomInteger.nextInteger(10) : minYear;
        maxYear = maxYear == 0 ? currentYear : maxYear;
        int year = RandomInteger.nextInteger(minYear, maxYear);
        int month = RandomInteger.nextInteger(1, 13);
        int day = RandomInteger.nextInteger(1, 32);
        if (month == 2) {
            day = Math.min(28, day);
        } else if (month == 4 || month == 6 || month == 9 || month == 11) {
            day = Math.min(30, day);
        }
        return ZonedDateTime.of(year, month, day, 0, 0, 0, 0, ZoneId.of("UTC"));
    }

    public static ZonedDateTime nextDateTime(int minYear, int maxYear) {
        return RandomDateTime.nextDate(minYear, maxYear).plusSeconds(RandomInteger.nextInteger(31536000));
    }

    public static ZonedDateTime updateDateTime(ZonedDateTime value) {
        return RandomDateTime.updateDateTime(value, 0.0f);
    }

    public static ZonedDateTime updateDateTime(ZonedDateTime value, float range) {
        float f = range = range != 0.0f ? range : 10.0f;
        if (range < 0.0f) {
            return value;
        }
        float days = RandomFloat.nextFloat(-range, range);
        return value.plusDays((int)days);
    }
}

