/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.config.connect;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicInteger;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IConfigurable;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.components.refer.IReferenceable;
import org.pipservices4.components.refer.IReferences;
import org.pipservices4.config.auth.CredentialParams;
import org.pipservices4.config.auth.CredentialResolver;
import org.pipservices4.config.connect.ConnectionParams;
import org.pipservices4.config.connect.ConnectionResolver;

public class HttpConnectionResolver
implements IReferenceable,
IConfigurable {
    protected ConnectionResolver _connectionResolver = new ConnectionResolver();
    protected CredentialResolver _credentialResolver = new CredentialResolver();

    @Override
    public void configure(ConfigParams config) {
        this._connectionResolver.configure(config);
        this._credentialResolver.configure(config);
    }

    @Override
    public void setReferences(IReferences references) {
        this._connectionResolver.setReferences(references);
        this._credentialResolver.setReferences(references);
    }

    private void validateConnection(IContext context, ConnectionParams connection, CredentialParams credential) throws ApplicationException {
        if (connection == null) {
            throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "NO_CONNECTION", "HTTP connection is not set");
        }
        String uri = connection.getUri();
        if (uri != null && !uri.isEmpty()) {
            return;
        }
        String protocol = connection.getProtocolWithDefault("http");
        if (!"http".equals(protocol) && !"https".equals(protocol)) {
            throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "WRONG_PROTOCOL", "Protocol is not supported by REST connection").withDetails("protocol", protocol);
        }
        String host = connection.getHost();
        if (host == null) {
            throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "NO_HOST", "Connection host is not set");
        }
        int port = connection.getPort();
        if (port == 0) {
            throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "NO_PORT", "Connection port is not set");
        }
        if (protocol.equals("https")) {
            if (credential == null) {
                throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "NO_CREDENTIAL", "SSL certificates are not configured for HTTPS protocol");
            }
            if (credential.getAsNullableString("internal_network") == null) {
                if (credential.getAsNullableString("ssl_key_file") == null) {
                    throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "NO_SSL_KEY_FILE", "SSL key file is not configured in credentials");
                }
                if (credential.getAsNullableString("ssl_crt_file") == null) {
                    throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "NO_SSL_CRT_FILE", "SSL crt file is not configured in credentials");
                }
            }
        }
    }

    private ConnectionParams composeConnection(List<ConnectionParams> connections, CredentialParams credential) {
        ConfigParams[] unpackConn = new ConfigParams[connections.size()];
        AtomicInteger i = new AtomicInteger();
        connections.forEach(c -> {
            unpackConn[i.get()] = ConfigParams.fromValue(c);
            i.getAndIncrement();
        });
        ConfigParams connection = ConnectionParams.mergeConfigs(unpackConn);
        Object uri = connection.getAsString("uri");
        if (uri == null || ((String)uri).isEmpty()) {
            String protocol = connection.getAsStringWithDefault("protocol", "http");
            String host = connection.getAsString("host");
            int port = connection.getAsInteger("port");
            uri = protocol + "://" + host;
            if (port > 0) {
                uri = (String)uri + ":" + port;
            }
            connection.setAsObject("uri", uri);
        } else {
            URI address = URI.create((String)uri);
            String protocol = address.getScheme();
            connection.setAsObject("protocol", protocol);
            connection.setAsObject("host", address.getHost());
            connection.setAsObject("port", address.getPort());
        }
        if (Objects.equals(connection.getAsString("protocol"), "https") && credential != null && credential.getAsNullableString("internal_network") == null) {
            connection = connection.override(credential);
        }
        return ConnectionParams.fromConfig(connection);
    }

    public ConnectionParams resolve(IContext context) throws ApplicationException {
        ConnectionParams connection = this._connectionResolver.resolve(context);
        CredentialParams credential = this._credentialResolver.lookup(context);
        this.validateConnection(context, connection, credential);
        return this.composeConnection(List.of(connection), credential);
    }

    public ConnectionParams resolveAll(IContext context) throws ApplicationException {
        ArrayList<ConnectionParams> connections = this._connectionResolver.resolveAll(context);
        CredentialParams credential = this._credentialResolver.lookup(context);
        connections = connections != null ? connections : new ArrayList<ConnectionParams>();
        for (ConnectionParams connection : connections) {
            this.validateConnection(context, connection, credential);
        }
        return this.composeConnection(connections, credential);
    }

    public void register(IContext context) throws ApplicationException {
        ConnectionParams connection = this._connectionResolver.resolve(context);
        CredentialParams credential = this._credentialResolver.lookup(context);
        this.validateConnection(context, connection, credential);
        this._connectionResolver.register(context, connection);
    }
}

