/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.config.connect;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.pipservices4.commons.data.StringValueMap;
import org.pipservices4.components.config.ConfigParams;

public class ConnectionParams
extends ConfigParams {
    private static final long serialVersionUID = 5769508200513539527L;

    public ConnectionParams() {
    }

    public ConnectionParams(Map<?, ?> map) {
        super(map);
    }

    public boolean useDiscovery() {
        return this.containsKey("discovery_key");
    }

    public String getDiscoveryKey() {
        return this.getAsNullableString("discovery_key");
    }

    public void setDiscoveryKey(String value) {
        this.put("discovery_key", value);
    }

    public String getProtocol() {
        return this.getAsNullableString("protocol");
    }

    public String getProtocolWithDefault(String defaultValue) {
        return this.getAsStringWithDefault("protocol", defaultValue);
    }

    public void setProtocol(String value) {
        this.put("protocol", value);
    }

    public String getHost() {
        String host = this.getAsNullableString("host");
        host = host != null ? host : this.getAsNullableString("ip");
        return host;
    }

    public void setHost(String value) {
        this.put("host", value);
    }

    public int getPort() {
        return this.getAsIntegerWithDefault("port", 8080);
    }

    public int getPortWithDefault(int defaultPort) {
        return super.getAsIntegerWithDefault("port", defaultPort);
    }

    public void setPort(int value) {
        this.setAsObject("port", value);
    }

    public String getUri() {
        return this.getAsNullableString("uri");
    }

    public void setUri(String value) {
        this.put("uri", value);
    }

    public static ConnectionParams fromString(String line) {
        StringValueMap map = StringValueMap.fromString(line);
        return new ConnectionParams((Map<?, ?>)map);
    }

    public static ConnectionParams fromTuples(Object ... tuples) {
        StringValueMap map = StringValueMap.fromTuplesArray(tuples);
        return new ConnectionParams((Map<?, ?>)map);
    }

    public static List<ConnectionParams> manyFromConfig(ConfigParams config, boolean configAsDefault) {
        ArrayList<ConnectionParams> result = new ArrayList<ConnectionParams>();
        ConfigParams connections = config.getSection("connections");
        if (!connections.isEmpty()) {
            List<String> connectionSections = connections.getSectionNames();
            for (String section : connectionSections) {
                ConfigParams connection = connections.getSection(section);
                result.add(new ConnectionParams((Map<?, ?>)connection));
            }
        } else {
            ConfigParams connection = config.getSection("connection");
            if (!connection.isEmpty()) {
                result.add(new ConnectionParams((Map<?, ?>)connection));
            } else if (configAsDefault) {
                result.add(new ConnectionParams((Map<?, ?>)config));
            }
        }
        return result;
    }

    public static List<ConnectionParams> manyFromConfig(ConfigParams config) {
        return ConnectionParams.manyFromConfig(config, true);
    }

    public static ConnectionParams fromConfig(ConfigParams config, boolean configAsDefault) {
        List<ConnectionParams> connections = ConnectionParams.manyFromConfig(config, configAsDefault);
        return !connections.isEmpty() ? connections.get(0) : null;
    }

    public static ConnectionParams fromConfig(ConfigParams config) {
        return ConnectionParams.fromConfig(config, true);
    }
}

