/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.config.config;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.commons.errors.ConfigException;
import org.pipservices4.commons.errors.FileException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.context.ContextResolver;
import org.pipservices4.components.context.IContext;
import org.pipservices4.config.config.FileConfigReader;

public class YamlConfigReader
extends FileConfigReader {
    private static final ObjectMapper yamlMapper = new ObjectMapper(new YAMLFactory());
    private static final TypeReference<Object> typeRef = new TypeReference<Object>(){};

    public YamlConfigReader() {
    }

    public YamlConfigReader(String path) {
        super(path);
    }

    public Object readObject(IContext context, ConfigParams parameters) throws ApplicationException {
        if (this._path == null) {
            throw new ConfigException(context != null ? ContextResolver.getTraceId(context) : null, "NO_PATH", "Missing config file path");
        }
        try {
            Path path = Paths.get(this._path, new String[0]);
            String yaml = new String(Files.readAllBytes(path));
            yaml = YamlConfigReader.parameterize(yaml, parameters);
            return yamlMapper.readValue(yaml, typeRef);
        }
        catch (Exception ex) {
            throw new FileException(context != null ? ContextResolver.getTraceId(context) : null, "READ_FAILED", "Failed reading configuration " + this._path + ": " + String.valueOf(ex)).withDetails("path", this._path).withCause(ex);
        }
    }

    @Override
    public ConfigParams readConfig(IContext context, ConfigParams parameters) throws ApplicationException {
        Object value = this.readObject(context, parameters);
        return ConfigParams.fromValue(value);
    }

    public static Object readObject(IContext context, String path, ConfigParams parameters) throws ApplicationException {
        return new YamlConfigReader(path).readObject(context, parameters);
    }

    public static ConfigParams readConfig(IContext context, String path, ConfigParams parameters) throws ApplicationException {
        return new YamlConfigReader(path).readConfig(context, parameters);
    }
}

