/*
 * Decompiled with CFR 0.152.
 */
package org.pipservices4.config.config;

import org.pipservices4.commons.errors.ApplicationException;
import org.pipservices4.components.config.ConfigParams;
import org.pipservices4.components.config.IReconfigurable;
import org.pipservices4.components.context.IContext;
import org.pipservices4.config.config.IConfigReader;

public abstract class CachedConfigReader
implements IConfigReader,
IReconfigurable {
    private long _lastRead = 0L;
    private ConfigParams _config;
    private long _timeout = 60000L;

    public long getTimeout() {
        return this._timeout;
    }

    public void setTimeout(long value) {
        this._timeout = value;
    }

    @Override
    public void configure(ConfigParams config) {
        this._timeout = config.getAsLongWithDefault("timeout", this._timeout);
    }

    protected abstract ConfigParams performReadConfig(IContext var1, ConfigParams var2) throws ApplicationException;

    @Override
    public ConfigParams readConfig(IContext context, ConfigParams parameters) throws ApplicationException {
        if (this._config != null && System.currentTimeMillis() < this._lastRead + this._timeout) {
            return this._config;
        }
        this._config = this.performReadConfig(context, parameters);
        this._lastRead = System.currentTimeMillis();
        return this._config;
    }

    public ConfigParams readConfigSection(IContext context, ConfigParams parameters, String section) throws ApplicationException {
        ConfigParams config = this.readConfig(context, parameters);
        return config != null ? config.getSection(section) : null;
    }
}

